<?php
defined('BASEPATH') OR exit('No direct script access allowed');
/**
* @category   FrontPortal
* @package    Portal
* @author     Abu Nawim <nawim@atilimited.net>
* @copyright  2015 ATI Limited Development Group
*/
class Library extends CI_Controller {

  private $user;
  public $user_id = null;

  public function __construct() {
    parent::__construct();
    if ($this->session->userdata('logged_in') == FALSE) {
      redirect('auth/login', 'refresh');
    }
    $user_session = $this->user = $this->session->userdata("logged_in");
    $this->user_id = $user_session['USER_TYPE'];
    $this->load->model('utilities');
  }

/**
 * @methodName checkPrevilege()
 * @access
 * @param  none
 * @return Mixed View
 */

  public function checkPrevilege($param = "") {
      if ($param == "") {
        $controller = $this->uri->segment(1, 'dashboard');
        $action = $this->uri->segment(2, 'index');
        $link = "$controller/$action";
      } else {
        $link = "$param";
      }
    return $this->security_model->get_all_checked_module_links_by_user($link, $this->user['USERGRP_ID'], $this->user['USERLVL_ID'], $this->user['USER_ID']);
  }

  /*
  * @methodName index
  * @access
  * @param  none
  * @author Abu Nawim <nawim@atilimited.net>
  * @return 
  */

    function index()
    {
      $data['contentTitle'] = ' Libray Book ';
      $data['breadcrumbs'] = array(
            'Admin' => '#',
            'Libray Book' => '#',
            );
      $data["previlages"] = $this->checkPrevilege();
        //$data['resident'] = $this->finance_model->residentBillInformation(); // select all data from  
      $data['content_view_page'] = 'admin/libray/add_book.php';
      $this->admin_template->display($data); 

    }
    

  /*
  * @methodName index
  * @access
  * @param  none
  * @author Abu Nawim <nawim@atilimited.net>
  * @return 
  */

    function dashboard()
    {

        $data['contentTitle'] = 'Libary Dashboard ';
        $data["breadcrumbs"] = array(
            "Admin" => "admin/index",
            "Dashboard" => '#'
            );
        $data['pageTitle'] = 'Online University Management System ';
        $current_session= $this->utilities->findByAttribute("adm_ysession", array("IS_CURRENT" => 1));
        $data['programs']  = $this->utilities->findAllByAttribute("ins_program", array("ACTIVE_STATUS" => 1)); 
        $data['content_view_page'] = 'admin/libray/libary_dashboard';
        $this->admin_template->display($data);

    }

    /*
    * @methodName addItem
    * @access
    * @param  none
    * @author Abu Nawim <nawim@atilimited.net>
    * @return 
    */


    function addItem()
    {
      $this->form_validation->set_rules('ISBN_NO','ISBN NO','required');
      $data["ac_type"] = 1;

      if ($this->form_validation->run() == FALSE) 
      {
      $data['department'] = $this->utilities->findAllByAttribute('m00_lkpdata', array('GRP_ID' => 15));
      $data['library_item_type'] = $this->utilities->findAllByAttribute('m00_lkpdata', array('GRP_ID' => 82));

      $data['author'] = $this->utilities->findAllByAttribute('lib_author', array('ACTIVE_STATUS' => 1));
      $data['publisher'] = $this->utilities->findAllByAttribute('lib_publisher', array('ACTIVE_STATUS' => 1));
      $data['supplier'] = $this->utilities->findAllByAttribute('inv_supplier', array('ACTIVE_STATUS' => 1));
     // var_dump($data);
       $data['content_view_page'] ='admin/libray/add_book';
 
      }
      else{
              require(APPPATH.'views/common/image_upload/class.upload.php');
              $itemPdf='';
              $itemCover='';
              $foo = new Upload($_FILES['PDF_VERSION']);

              if ($foo->uploaded) {
                // large size image                         
                $foo->image_border= 1;       
                $foo->allowed = array('image/*');
                $foo->Process('upload/library/pdf/');
                if($foo->processed){
                  $itemPdf=  $foo->file_src_name;
                }else{
                  echo  'error : ' . $foo->error;
                }
              }
              $sig_photo = new Upload($_FILES['COVER_IMAGE']);
              if ($sig_photo->uploaded) {
                // large size image
                $sig_photo->image_border          = 1;         
                $sig_photo->allowed = array('image/*');
                $sig_photo->Process('upload/library/cover/');
                if($sig_photo->processed){
                  $itemCover=  $sig_photo->file_src_name;
                }else{
                  echo  'error : ' . $sig_photo->error;
                }
              }

             $itemInfo = array(
                    'ISBN_NO' => $this->input->post('ISBN_NO'),
                    'ITEM_NAME' => $this->input->post('ITEM_NAME'),
                    'SUB_TITLE' => $this->input->post('SUB_TITLE'),
                    'DEPARTMENT' => $this->input->post('DEPARTMENT'),
                    'LANGUAGE' => $this->input->post('LANGUAGE'),
                    'AUTHOR_ID' => $this->input->post('AUTHOR_ID'),
                    //'EDITOR_NAME' => $this->input->post('EDITOR_NAME'),
                    'EDITION_NO' => $this->input->post('EDITION_NO'),
                    'BOOK_CELL_NO' => $this->input->post('BOOK_CELL_NO'),
                    'BOOK_TYPE_ID' => $this->input->post('BOOK_TYPE_ID'),
                    'SUPPILER_ID' => $this->input->post('SUPPILER_ID'),
                    'PRICE' => $this->input->post('PRICE'),
                    'NUMBER_OF_PAGE' => $this->input->post('NUMBER_OF_PAGE'),
                    'CLUE_PAGE' => $this->input->post('CLUE_PAGE'),
                    'PUBLISHER_ID' => $this->input->post('PUBLISHER_ID'),
                    'PUBLICATION_YEAR' => $this->input->post('PUBLICATION_YEAR'),
                    'PUBLICATION_PLACE' => $this->input->post('PUBLICATION_PLACE'),
                    //'BOOK_SIZE' => $this->input->post('BOOK_SIZE'),
                    'PDF_VERSION' => $itemPdf,
                    'COVER_IMAGE' => $itemCover,
                    'COMMENT' => $this->input->post('COMMENT'),
                );
             //var_dump($itemInfo); die();

              $itemInfoResult= $this->library_model->insert('lib_item', $itemInfo);

              $this->session->set_flashdata('Success', 'Successfully Inserted');
              redirect('library/itemList');
             // echo "string OK Insert";
      }
      $this->admin_template->display($data);   
   
  }

   /*
    * @methodName itemList
    * @access
    * @param  none
    * @author Abu Nawim <nawim@atilimited.net>
    * @return 
    */

    public function itemList() {

        $data['contentTitle'] = 'Item List';
        $data['breadcrumbs'] = array(
          'Admin' => '#',
          'Item List' => '#',
          );
        $data["previlages"] = $this->checkPrevilege();
        $data['item_list'] = $this->library_model->itemInfo(); 
        $data['content_view_page'] = 'admin/libray/libary_list';
        $this->admin_template->display($data);
    }

   /*
    * @methodName itemUpdate
    * @access
    * @param  none
    * @author Abu Nawim <nawim@atilimited.net>
    * @return 
    */
    public function itemUpdate(){
        $ITEM_ID = $this->uri->segment(3);
         $data["ac_type"] = 1;
        //var_dump($ITEM_ID); die();
        // $data['ITEM_ID'] = $this->employee_model->findEmpById($ITEM_ID);
        $data['item'] = $this->utilities->findByAttribute('lib_item', array('ITEM_ID' => $ITEM_ID));
        $this->form_validation->set_rules('ISBN_NO','ISBN NO','required');
        if ($this->form_validation->run() == FALSE) {

         $data['department'] = $this->utilities->findAllByAttribute('m00_lkpdata', array('GRP_ID' => 15));
        $data['library_item_type'] = $this->utilities->findAllByAttribute('m00_lkpdata', array('GRP_ID' => 82));
        $data['author'] = $this->utilities->findAllByAttribute('lib_author', array('ACTIVE_STATUS' => 1));
        $data['publisher'] = $this->utilities->findAllByAttribute('lib_publisher', array('ACTIVE_STATUS' => 1));
        $data['supplier'] = $this->utilities->findAllByAttribute('inv_supplier', array('ACTIVE_STATUS' => 1));

        //$data['supplier'] = $this->utilities->findAllByAttribute('inv_supplier', array('ACTIVE_STATUS' => 1));
        

        $data['content_view_page'] ='admin/libray/edit_item';

        }else{

                require(APPPATH.'views/common/image_upload/class.upload.php');
                $itemPdf='';
                $itemCover='';
                $foo = new Upload($_FILES['PDF_VERSION']);

                if ($foo->uploaded) {
                  // large size image          
                  $foo->image_border= 1;
                  $foo->allowed = array('image/*');
                  $foo->Process('upload/library/pdf/');
                  if($foo->processed){
                    $itemPdf=  $foo->file_src_name;
                  }else{
                    echo  'error : ' . $foo->error;
                  }
                }
                $sig_photo = new Upload($_FILES['COVER_IMAGE']);
                if ($sig_photo->uploaded) {
                  // large size image
                  $sig_photo->image_border = 1;
                  $sig_photo->allowed = array('image/*');
                  $sig_photo->Process('upload/library/cover/');
                  if($sig_photo->processed){
                    $itemCover=  $sig_photo->file_src_name;
                  }else{
                    echo  'error : ' . $sig_photo->error;
                  }
                }

               $itemInfo = array(
                      'ISBN_NO' => $this->input->post('ISBN_NO'),
                      'ITEM_NAME' => $this->input->post('ITEM_NAME'),
                      'SUB_TITLE' => $this->input->post('SUB_TITLE'),
                      'DEPARTMENT' => $this->input->post('DEPARTMENT'),
                      'LANGUAGE' => $this->input->post('LANGUAGE'),
                      'AUTHOR_ID' => $this->input->post('AUTHOR_ID'),
                      //'EDITOR_NAME' => $this->input->post('EDITOR_NAME'),
                      'EDITION_NO' => $this->input->post('EDITION_NO'),
                      'BOOK_CELL_NO' => $this->input->post('BOOK_CELL_NO'),
                      'BOOK_TYPE_ID' => $this->input->post('BOOK_TYPE_ID'),
                      'SUPPILER_ID' => $this->input->post('SUPPILER_ID'),
                      'PRICE' => $this->input->post('PRICE'),
                      'NUMBER_OF_PAGE' => $this->input->post('NUMBER_OF_PAGE'),
                      'CLUE_PAGE' => $this->input->post('CLUE_PAGE'),
                      'PUBLISHER_ID' => $this->input->post('PUBLISHER_ID'),
                      'PUBLICATION_YEAR' => $this->input->post('PUBLICATION_YEAR'),
                      'PUBLICATION_PLACE' => $this->input->post('PUBLICATION_PLACE'),
                      //'BOOK_SIZE' => $this->input->post('BOOK_SIZE'),
                      'PDF_VERSION' => $itemPdf,
                      'COVER_IMAGE' => $itemCover,
                      'COMMENT' => $this->input->post('COMMENT'),
                  );

                $testall=$this->utilities->updateData('lib_item', $itemInfo, array('ITEM_ID' => $ITEM_ID));
                $this->session->set_flashdata('Success', ' Update Successfully ');
                      redirect('library/itemList');
        }
        $this->admin_template->display($data); 
    }

    /*
    * @methodName itemModal
    * @access
    * @param  none
    * @author Abu Nawim <nawim@atilimited.net>
    * @return 
    */


    public function itemModal()
    {
      $ITEM_ID = $_POST['ITEM_ID'];
      $data['ITEM_ID'] = $ITEM_ID;
      $data["item_info"] = $this->library_model->singleItemLiberayInfo($ITEM_ID);
       //$data["emp_desi"] = $this->employee_model->getEmployeeDesignation($EMP_ID);
        //echo "<pre>"; print_r($data); exit; echo "</pre>";
       //var_dump($data); die();
      echo $this->load->view('admin/libray/details_modal_view', $data, true);
    }

    /*
    * @methodName stock
    * @access
    * @param  none
    * @author Abu Nawim <nawim@atilimited.net>
    * @return 
    */


    public function stock()
    {


        $data['contentTitle'] = 'Library Stock Item List';
        $data['breadcrumbs'] = array(
          'Admin' => '#',
          'Library Stock Item List' => '#',
          );
        $data["previlages"] = $this->checkPrevilege();
        $data['item'] = $this->utilities->findAllByAttribute('lib_item', array('ACTIVE_STATUS' =>  1));
        $data['supplier'] = $this->utilities->findAllByAttribute('inv_supplier', array('ACTIVE_STATUS' => 1));
       
       //var_dump($data);
        $data['content_view_page'] = 'admin/libray/add_stock';
        $this->admin_template->display($data);
    }

    /*
    * @methodName addStock
    * @access
    * @param  none
    * @author Abu Nawim <nawim@atilimited.net>
    * @return 
    */


    public function addStock()
    {
          $INVOICE_NO=$this->input->post('INVOICE_NO');
          $ITEM_NAME_ID=$this->input->post('ITEM_NAME_ID');
          $SUPPLIER_ID=$this->input->post('SUPPLIER_ID');
          $REMARKS=$this->input->post('REMARKS');
          $REMARKS1=$this->input->post('REMARKS1');
          
          $QUENTITY=$this->input->post('QUENTITY');
          $RECEIVE_DATE = date('Y-m-d',strtotime($this->input->post('RECEIVE_DATE')));
          //var_dump(sizeof($ITEM_NAME_ID);); die();

            $add_invoice_data=array( 
                'INVOICE_NO' => $INVOICE_NO,
                'SUPPLIER_ID' => $SUPPLIER_ID,
                'REMARKS' => $REMARKS1,
                'RECEIVE_DATE'=>$RECEIVE_DATE
                );
               
          $this->utilities->insertData($add_invoice_data, 'lib_invoice');

          $LIB_INVOICE_ID=$this->db->query("SELECT MAX(LIB_INVOICE_ID) as LIB_INVOICE_ID FROM lib_invoice")->result();
          $test=$LIB_INVOICE_ID;


          if(!empty($ITEM_NAME_ID)){
            for ($i = 0; $i < sizeof($ITEM_NAME_ID); $i++) {
  
              for ($z = 0; $z < $QUENTITY[$i]; $z++) {
             
              $add_stock_data=array( 
                'ITEM_ID' => $ITEM_NAME_ID[$i],
                'LIB_INVOICE_ID' => $LIB_INVOICE_ID[0]->LIB_INVOICE_ID,
                'REMARKS' => $REMARKS[$i]
               
                );
               
                $this->utilities->insertData($add_stock_data, 'lib_stock');

                }

            }
                    
          }

        $this->session->set_flashdata('Success', 'Successfully Inserted');
        redirect('library/listStock');
    
    }

    /*
    * @methodName listStock
    * @access
    * @param  none
    * @author Abu Nawim <nawim@atilimited.net>
    * @return 
    */


    public function listStock (){

     $data['contentTitle'] = 'Item List';
            $data['breadcrumbs'] = array(
              'Admin' => '#',
              'Item List' => '#',
              );
            $data["previlages"] = $this->checkPrevilege();
            $data['stock_item_list'] = $this->library_model->stockItemList(); 
            $data['content_view_page'] = 'admin/libray/stock_list';

           // var_dump($data); die();
            $this->admin_template->display($data);
      }



      /**
     * @methodName deleteMasterRow()
     * @access
     * @param  none
     * @author Md. Reazul Islam <reazul@atilimited.net>
     * @return Mixed Template
     */

    function deleteItemReceive()
    {
        $m_id = $this->input->post('m_id');
        $this->db->query("DELETE FROM lib_item_receive WHERE LIB_ITEM_NUMBER = $m_id");
        echo "Y";
    }



    /*
    * @methodName applicationForLibraryMember
    * @access
    * @param  none
    * @author Abu Nawim <nawim@atilimited.net>
    * @return 
    */

    public function applicationForLibraryMember() {
        $data['contentTitle'] = 'Library Member List';
        $data['breadcrumbs'] = array(
          'Admin' => '#',
          'Item List' => '#',
          );
        $data["previlages"] = $this->checkPrevilege();
        $data['libray_member'] = $this->library_model->libraryMember(); 


        $data['content_view_page'] = 'admin/libray/libary_member_list';

        //var_dump($data); die();
        $this->admin_template->display($data);
    }


    /*
    * @methodName libraryMemberModel
    * @access
    * @param  none
    * @author Abu Nawim <nawim@atilimited.net>
    * @return 
    */


    public function libraryMemberModel()
    {
      $MEBBER_ID = $_POST['MEBBER_ID'];
      $data['MEBBER_ID'] = $MEBBER_ID;

      $data['student_details'] = $this->student_model->getStudentInfoAll($MEBBER_ID);
      $data['local_present_adddress'] = $this->student_model->getLocalPresentAddress($MEBBER_ID);
      $data['local_permanent_adddress'] = $this->student_model->getLocalPermanentAddress($MEBBER_ID); 
      echo $this->load->view('admin/libray/library_member_details_model_view', $data, true);
    }

    /*
    * @methodName libraryMemberUpdate
    * @access
    * @param  none
    * @author Abu Nawim <nawim@atilimited.net>
    * @return 
    */

    public function libraryMemberUpdate(){

       $MEBBER_ID = $this->uri->segment(3);
       $data['contentTitle'] = 'Library Member Update';
        $data['breadcrumbs'] = array(
            'Library ' => '#',
            'Member Update' => '#',
        );

        $data["previlages"] = $this->checkPrevilege();

       $data['library_member_info'] = $this->utilities->findAllByAttribute('lib_members', array('MEBBER_ID' => $MEBBER_ID));
        $data['content_view_page'] = 'admin/libray/libary_member_update';
        $this->admin_template->display($data);

    }



    /*
    * @methodName libraryMemberUpdateSave
    * @access
    * @param  none
    * @author Abu Nawim <nawim@atilimited.net>
    * @return 
    */

    public function libraryMemberUpdateSave(){


        $MEBBER_ID=$this->input->post('MEBBER_ID');
         
        $library_member_info = array(                
          'MEMBER_NO' => $this->input->post('MEMBER_NO'),
          'ACTIVE_STATUS' => $this->input->post('ACTIVE_STATUS'),
          'START_DT' => date('Y-m-d',strtotime($this->input->post('START_DT')))
  
          );

       $this->utilities->updateData('lib_members', $library_member_info, array('MEBBER_ID' => $MEBBER_ID));


        $data['contentTitle'] = 'Library Member List';
        $data['breadcrumbs'] = array(
          'Admin' => '#',
          'Item List' => '#',
          );
        $data["previlages"] = $this->checkPrevilege();
        $data['libray_member'] = $this->library_model->libraryMember(); 


        $data['content_view_page'] = 'admin/libray/libary_member_list';

        //var_dump($data); die();
        $this->admin_template->display($data);

    }



    /*
    * @methodName libraryMemberPrint
    * @access
    * @param  none
    * @author Abu Nawim <nawim@atilimited.net>
    * @return 
    */

    public function libraryMemberPrint(){

       $MEBBER_ID = $this->uri->segment(3);
       $data['contentTitle'] = 'Library Member Update';
        $data['breadcrumbs'] = array(
            'Library ' => '#',
            'Member Update' => '#',
        );

        $data["previlages"] = $this->checkPrevilege();

        $data['student_details'] = $this->student_model->getStudentInfoAll($MEBBER_ID);
        $data['local_present_adddress'] = $this->student_model->getLocalPresentAddress($MEBBER_ID);
        $data['local_permanent_adddress'] = $this->student_model->getLocalPermanentAddress($MEBBER_ID); 
        $data['library_policy']=$this->utilities->findAllByAttribute('m00_lkpdata',array('GRP_ID'=>83));
        $data['library_member_info'] = $this->library_model->findAllByAttributeLibrary('lib_members', array('MEBBER_ID' => $MEBBER_ID));
       
        $data['content_view_page'] = 'admin/libray/libary_member_print';

       //var_dump($data); 
        $this->admin_template->display($data);

    }

    /*
    * @methodName libraryMemberPdf
    * @access
    * @param  none
    * @author Abu Nawim <nawim@atilimited.net>
    * @return 
    */


    function libraryMemberPdf()
    {

      
      $STUDENT_ID=$this->input->post('STUDENT_ID');
      var_dump($STUDENT_ID);
      $data['pageTitle'] = 'Print PDF';      
      $data['emp_info'] = $this->employee_model->findEmpById($STUDENT_ID);

      $data['student_details'] = $this->student_model->getStudentInfoAll($STUDENT_ID);
      $data['local_present_adddress'] = $this->student_model->getLocalPresentAddress($STUDENT_ID);
      $data['local_permanent_adddress'] = $this->student_model->getLocalPermanentAddress($STUDENT_ID); 
      $data['library_policy']=$this->utilities->findAllByAttribute('m00_lkpdata',array('GRP_ID'=>83));
      $data['library_member_info'] = $this->library_model->findAllByAttributeLibrary('lib_members', array('MEBBER_ID' => $STUDENT_ID));
      include('mpdf/mpdf.php');
      $mpdf = new mPDF();
      $mpdf->SetTitle('Employee Information');
      $mpdf->mirrorMargins = 1;
      $mpdf->useOnlyCoreFonts = true;
      $report = $this->load->view('admin/libray/library_member_pdf', $data, TRUE);
        //$footer = $this->load->view('admin/emp/emp_list_info_footer', $data, TRUE);
      $mpdf->WriteHTML("$report");
      $mpdf->SetHTMLFooter("$footer");
      $mpdf->Output();
      exit;
    }
}
