/*
 * @license
 *
 * Multiselect v2.1.6
 * http://crlcu.github.io/multiselect/
 *
 * Copyright (c) 2015 Adrian Crisan
 * Licensed under the MIT license (https://github.com/crlcu/multiselect/blob/master/LICENSE)
 */
if ("undefined" == typeof jQuery)throw new Error("multiselect requires jQuery");
!function (t) {
    "use strict";
    var e = t.fn.jquery.split(" ")[0].split(".");
    if (e[0] < 2 && e[1] < 7)throw new Error("multiselect requires jQuery version 1.7 or higher")
}(jQuery), function (t) {
    "function" == typeof define && define.amd ? define(["jquery"], t) : t(jQuery)
}(function (t) {
    "use strict";
    var e = function (t) {
        function e(e, o) {
            var i = e.prop("id");
            this.left = e, this.right = t(t(o.right).length ? o.right : "#" + i + "_to"), this.actions = {
                leftAll: t(t(o.leftAll).length ? o.leftAll : "#" + i + "_leftAll"),
                rightAll: t(t(o.rightAll).length ? o.rightAll : "#" + i + "_rightAll"),
                leftSelected: t(t(o.leftSelected).length ? o.leftSelected : "#" + i + "_leftSelected"),
                rightSelected: t(t(o.rightSelected).length ? o.rightSelected : "#" + i + "_rightSelected"),
                undo: t(t(o.undo).length ? o.undo : "#" + i + "_undo"),
                redo: t(t(o.redo).length ? o.redo : "#" + i + "_redo")
            }, delete o.leftAll, delete o.leftSelected, delete o.right, delete o.rightAll, delete o.rightSelected, this.options = {
                keepRenderingSort: o.keepRenderingSort,
                submitAllLeft: void 0 !== o.submitAllLeft ? o.submitAllLeft : !0,
                submitAllRight: void 0 !== o.submitAllRight ? o.submitAllLeft : !0,
                search: o.search
            }, delete o.keepRenderingSort, o.submitAllLeft, o.submitAllRight, o.search, this.callbacks = o, this.init()
        }

        return e.prototype = {
            undoStack: [], redoStack: [], init: function () {
                var e = this;
                e.options.keepRenderingSort && (e.skipInitSort = !0, e.callbacks.sort = function (e, o) {
                    return t(e).data("position") > t(o).data("position") ? 1 : -1
                }, e.left.find("option").each(function (e, o) {
                    t(o).data("position", e)
                }), e.right.find("option").each(function (e, o) {
                    t(o).data("position", e)
                })), "function" == typeof e.callbacks.startUp && e.callbacks.startUp(e.left, e.right), e.skipInitSort || "function" != typeof e.callbacks.sort || (e.left.find("option").sort(e.callbacks.sort).appendTo(e.left), e.right.each(function (o, i) {
                    t(i).find("option").sort(e.callbacks.sort).appendTo(i)
                })), e.options.search && e.options.search.left && (e.options.search.left = t(e.options.search.left), e.left.before(e.options.search.left)), e.options.search && e.options.search.right && (e.options.search.right = t(e.options.search.right), e.right.before(t(e.options.search.right))), e.events(e.actions)
            }, events: function (e) {
                var o = this;
                o.left.on("dblclick", "option", function (t) {
                    t.preventDefault(), o.moveToRight(this, t)
                }), o.right.on("dblclick", "option", function (t) {
                    t.preventDefault(), o.moveToLeft(this, t)
                }), o.options.search && o.options.search.left && o.options.search.left.on("keyup", function (e) {
                    var i = new RegExp(this.value, "ig");
                    o.left.find("option").each(function (e, o) {
                        o.text.search(i) >= 0 ? (t(o).parent().is("span") && t(o).parent().replaceWith(o), t(o).show()) : t(o).wrap("<span>").hide()
                    })
                }), o.options.search && o.options.search.right && o.options.search.right.on("keyup", function (e) {
                    var i = new RegExp(this.value, "ig");
                    o.right.find("option").each(function (e, o) {
                        o.text.search(i) >= 0 ? t(o).show() : t(o).hide()
                    })
                }), o.right.closest("form").on("submit", function (t) {
                    o.left.children().prop("selected", o.options.submitAllLeft), o.right.children().prop("selected", o.options.submitAllRight)
                }), (navigator.userAgent.match(/MSIE/i) || navigator.userAgent.indexOf("Trident/") > 0 || navigator.userAgent.indexOf("Edge/") > 0) && (o.left.dblclick(function (t) {
                    e.rightSelected.trigger("click")
                }), o.right.dblclick(function (t) {
                    e.leftSelected.trigger("click")
                })), e.rightSelected.on("click", function (e) {
                    e.preventDefault();
                    var i = o.left.find("option:selected");
                    i && o.moveToRight(i, e), t(this).blur()
                }), e.leftSelected.on("click", function (e) {
                    e.preventDefault();
                    var i = o.right.find("option:selected");
                    i && o.moveToLeft(i, e), t(this).blur()
                }), e.rightAll.on("click", function (e) {
                    e.preventDefault();
                    var i = o.left.find("option");
                    i && o.moveToRight(i, e), t(this).blur()
                }), e.leftAll.on("click", function (e) {
                    e.preventDefault();
                    var i = o.right.find("option");
                    i && o.moveToLeft(i, e), t(this).blur()
                }), e.undo.on("click", function (t) {
                    t.preventDefault(), o.undo(t)
                }), e.redo.on("click", function (t) {
                    t.preventDefault(), o.redo(t)
                })
            }, moveToRight: function (t, e, o, i) {
                var n = this;
                return "function" == typeof n.callbacks.moveToRight ? n.callbacks.moveToRight(n, t, e, o, i) : "function" != typeof n.callbacks.beforeMoveToRight || o || n.callbacks.beforeMoveToRight(n.left, n.right, t) ? (n.right.append(t), i || (n.undoStack.push(["right", t]), n.redoStack = []), "function" != typeof n.callbacks.sort || o || n.right.find("option").sort(n.callbacks.sort).appendTo(n.right), "function" != typeof n.callbacks.afterMoveToRight || o || n.callbacks.afterMoveToRight(n.left, n.right, t), n) : !1
            }, moveToLeft: function (t, e, o, i) {
                var n = this;
                return "function" == typeof n.callbacks.moveToLeft ? n.callbacks.moveToLeft(n, t, e, o, i) : "function" != typeof n.callbacks.beforeMoveToLeft || o || n.callbacks.beforeMoveToLeft(n.left, n.right, t) ? (n.left.append(t), i || (n.undoStack.push(["left", t]), n.redoStack = []), "function" != typeof n.callbacks.sort || o || n.left.find("option").sort(n.callbacks.sort).appendTo(n.left), "function" != typeof n.callbacks.afterMoveToLeft || o || n.callbacks.afterMoveToLeft(n.left, n.right, t), n) : !1
            }, undo: function (t) {
                var e = this, o = e.undoStack.pop();
                if (o)switch (e.redoStack.push(o), o[0]) {
                    case"left":
                        e.moveToRight(o[1], t, !1, !0);
                        break;
                    case"right":
                        e.moveToLeft(o[1], t, !1, !0)
                }
            }, redo: function (t) {
                var e = this, o = e.redoStack.pop();
                if (o)switch (e.undoStack.push(o), o[0]) {
                    case"left":
                        e.moveToLeft(o[1], t, !1, !0);
                        break;
                    case"right":
                        e.moveToRight(o[1], t, !1, !0)
                }
            }
        }, e
    }(t);
    t.multiselect = {
        defaults: {
            startUp: function (t, e) {
                e.find("option").each(function (e, o) {
                    t.find('option[value="' + o.value + '"]').remove()
                })
            }, beforeMoveToRight: function (t, e, o) {
                return !0
            }, afterMoveToRight: function (t, e, o) {
            }, beforeMoveToLeft: function (t, e, o) {
                return !0
            }, afterMoveToLeft: function (t, e, o) {
            }, sort: function (t, e) {
                return "NA" == t.innerHTML ? 1 : "NA" == e.innerHTML ? -1 : t.innerHTML > e.innerHTML ? 1 : -1
            }
        }
    }, t.fn.multiselect = function (o) {
        return this.each(function () {
            var i = t(this), n = i.data(), r = t.extend({}, t.multiselect.defaults, n, o);
            return new e(i, r)
        })
    }
});
