<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;

class Cart extends Model
{
    protected $table = 'sf_carts';

    protected $guarded = [];

    public static function carts($customer_id){
        return DB::table('sf_carts')
            ->select('sf_carts.*', 'sf_product_info.PROD_NAME', 'sf_product_info.IS_SELL_BOX', 'sf_product_info.UNIT_PRICE', 'sf_product_info.BOX_PRICE', 'sf_product_info.PRODUCT_IMG', 'sf_policy.DISC_PCT', 'sf_policy.FREE_QTY')
            ->leftJoin('sf_product_info', 'sf_carts.PRODUCT_ID', '=', 'sf_product_info.PRODUCT_ID')
            ->leftJoin('sf_policy', 'sf_product_info.PRODUCT_ID','=','sf_policy.PRODUCT_ID')
            ->where('CUSTOMER_ID', $customer_id)
            ->get();
    }

    public static function cartDetails($customer_id){
        return DB::table('sf_carts')
            ->select('sf_carts.*', 'sf_product_info.*')
            ->leftJoin('sf_product_info', 'sf_carts.PRODUCT_ID', '=', 'sf_product_info.PRODUCT_ID')
            ->where('CUSTOMER_ID', $customer_id)
            ->get();
    }

    public static function hasProduct($customerId, $productId){
        return DB::table('sf_carts')
            ->where('CUSTOMER_ID', $customerId)
            ->where('PRODUCT_ID', $productId)
            ->first();
    }

    public static function deleteRow($customerId, $productId ){
        return DB::table('sf_carts')
            ->where('CUSTOMER_ID', $customerId)
            ->where('PRODUCT_ID', $productId)
            ->delete();
    }

    public static function deleteByCustomerId($customerId){
        return DB::table('sf_carts')
            ->where('CUSTOMER_ID', $customerId)
            ->delete();
    }
}
