<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;

class CelOrderInfo extends Model
{
    public static function orders($celebrityId, $orderStatus){
        $colName = null;
        if($orderStatus=='delivered'){
            $colName = 'ORDER_FLG';
        }
        if($orderStatus=='accepted'){
            $colName = 'DELIVERY_FLG';
        }
        $data = DB::table('sf_ordermst')
            ->leftJoin('sf_customers', 'sf_ordermst.CUSTOMER_ID', '=', 'sf_customers.CUSTOMER_ID')
            ->where(function ($query) use($celebrityId, $orderStatus, $colName) {
                if(!empty($celebrityId)) {
                    $query->where('CELEBRITY_ID', '=', $celebrityId);
                }
                if(!empty($orderStatus)) {
                    $query->where($colName, '=', 1);
                }
            })
            ->get();

        return $data;
    }

}
