<?php

namespace App;
use Illuminate\Support\Facades\DB;
use Illuminate\Database\Eloquent\Model;

class CelebrityProfile extends Model
{
    public static function getCelebrityInfo($id){
        $data = DB::table('sf_celebrity_reg')
            ->select('sf_celebrity_reg.*','sf_celebrity_page.*', 'sf_celebrity_img.IMAGE_LINK')
            ->leftJoin('sf_celebrity_page','sf_celebrity_reg.CELEBRITY_ID','=','sf_celebrity_page.CELEBRITY_ID')
            ->leftJoin('sf_celebrity_img','sf_celebrity_page.CELEBRITYPAGE_ID','=','sf_celebrity_img.CELEBRITYPAGE_ID')
            ->where('sf_celebrity_reg.CELEBRITY_ID',$id)
            ->first();
        return $data;
    }
    public static function getMediaInfo($id){
        return DB::table('sf_media_info')
            ->where('CELEBRITY_ID',$id)
            ->get();
    }
}
