<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;

class CelebrityRegistration extends Model
{
    // get registered member
    public static function celebrities(){
        return DB::table('sf_celebrity_reg')
            ->select('sf_celebrity_reg.*','country.LDATA_NAME as country_name','province.LDATA_NAME as province_name','district.LDATA_NAME as district_name','region.LDATA_NAME as region_name','bank.LDATA_NAME as bank_name')
            ->leftJoin('sc_lkpdata as country','sf_celebrity_reg.COUNTRY','=','country.LKP_DATAID')
            ->leftJoin('sc_lkpdata as province','sf_celebrity_reg.PROVINCE_ID','=','province.LKP_DATAID')
            ->leftJoin('sc_lkpdata as district','sf_celebrity_reg.DISTRICT','=','district.LKP_DATAID')
            ->leftJoin('sc_lkpdata as region','sf_celebrity_reg.REGION_ID','=','region.LKP_DATAID')
            ->leftJoin('sc_lkpdata as bank','sf_celebrity_reg.BANK_ID','=','bank.LKP_DATAID')
            ->get();
    }
    // add member
    public static function addCelebrity($request){
        $registrationId = DB::table('sf_celebrity_reg')->insertGetId([
            'MEMBERS_NAME' => $request->input('MEMBERS_NAME'),
            'COUNTRY'      => $request->input('COUNTRY'),
            'PROVINCE_ID'  => $request->input('PROVINCE_ID'),
            'DISTRICT'     => $request->input('DISTRICT'),
            'REGION_ID'    => $request->input('REGION_ID'),
            'ADDRESS'      => $request->input('ADDRESS'),
            'GENDER'       => $request->input('GENDER'),
            'MOBILE_NO'    => $request->input('MOBILE_NO'),
            'BANK_ID'      => $request->input('BANK_ID'),
            'BRANCH_NAME'  => $request->input('BRANCH_NAME'),
            'AC_NO'        => $request->input('AC_NO'),
            'BNK_MOB_NO'   => $request->input('BNK_MOB_NO'),
            'DESIGNATION'  => $request->input('DESIGNATION'),
            'ACTIVE_FLG'   => $request->input('ACTIVE_FLG'),
            'CREATED_BY'   => auth()->user()->id,
            'CREATED_AT'   => date('Y-m-d h:i:s'),
        ]);
        return $registrationId;
    }
    // add celebrity page
    public static function addCelebrityPage($request,$celebrityId){
        $celebrityPageId = DB::table('sf_celebrity_page')->insertGetId([
            'CELEBRITY_ID'   => $celebrityId,
            'PERSONAL_OPINION'  => $request->input('PERSONAL_OPINION'),
            'ABOUT_OUR_SERVICE' => $request->input('ABOUT_OUR_SERVICE'),
            'CAMPAIGN_TAGLINE'  => $request->input('CAMPAIGN_TAGLINE'),
            'CREATED_BY'        => auth()->user()->id,
            'CREATED_AT'        => date('Y-m-d h:i:s'),
        ]);
        return $celebrityPageId;
    }
    // add celebrity image
    public static function addMemberImg($data){
        return DB::table('sf_celebrity_img')->insert($data);
    }
    // show member form info
    public static function getMemberInfo($id){
        return DB::table('sf_celebrity_reg')
            ->select('sf_celebrity_reg.*','sf_celebrity_page.*')
            ->leftJoin('sf_celebrity_page','sf_celebrity_reg.CELEBRITY_ID','=','sf_celebrity_page.CELEBRITY_ID')
            ->where('sf_celebrity_reg.CELEBRITY_ID',$id)
            ->first();
    }
    // show lookup data
    public static function getLookUpData($id){
        return DB::table('sf_celebrity_reg')
            ->select('sf_celebrity_reg.*','country.LDATA_NAME as country_name','province.LDATA_NAME as province_name','district.LDATA_NAME as district_name','region.LDATA_NAME as region_name','bank.LDATA_NAME as bank_name')
            ->leftJoin('sc_lkpdata as country','sf_celebrity_reg.COUNTRY','=','country.LKP_DATAID')
            ->leftJoin('sc_lkpdata as province','sf_celebrity_reg.PROVINCE_ID','=','province.LKP_DATAID')
            ->leftJoin('sc_lkpdata as district','sf_celebrity_reg.DISTRICT','=','district.LKP_DATAID')
            ->leftJoin('sc_lkpdata as region','sf_celebrity_reg.REGION_ID','=','region.LKP_DATAID')
            ->leftJoin('sc_lkpdata as bank','sf_celebrity_reg.BANK_ID','=','bank.LKP_DATAID')
            ->where('sf_celebrity_reg.CELEBRITY_ID',$id)
            ->first();
    }
    // show media info
    public static function getMediaInfo($id){
        return DB::table('sf_media_info')
            ->where('CELEBRITY_ID',$id)
            ->get();
    }
    // show page image
    public static function getMediaImg($id){
        return DB::table('sf_celebrity_img')
            ->where('CELEBRITYPAGE_ID',$id)
            ->get();
    }
    public static function getProfileImg($id){
        return DB::table('sf_celebrity_img')
            ->where('CELEBRITYPAGE_ID',$id)
            ->first();
    }
    // edit member form info
    public static function editMemberInfo($id){
        return DB::table('sf_celebrity_reg')
            ->select('sf_celebrity_reg.*','sf_celebrity_page.*')
            ->leftJoin('sf_celebrity_page','sf_celebrity_reg.CELEBRITY_ID','=','sf_celebrity_page.CELEBRITY_ID')
            ->where('sf_celebrity_reg.CELEBRITY_ID',$id)
            ->first();
    }


    // update general info
    public static function updateCelebrity($request,$id){
        return DB::table('sf_celebrity_reg')->where('CELEBRITY_ID', '=' , $id)->update([
            'MEMBERS_NAME' => $request->input('MEMBERS_NAME'),
            'COUNTRY'      => $request->input('COUNTRY'),
            'PROVINCE_ID'  => $request->input('PROVINCE_ID'),
            'DISTRICT'     => $request->input('DISTRICT'),
            'REGION_ID'    => $request->input('REGION_ID'),
            'ADDRESS'      => $request->input('ADDRESS'),
            'GENDER'       => $request->input('GENDER'),
            'MOBILE_NO'    => $request->input('MOBILE_NO'),
            'BANK_ID'      => $request->input('BANK_ID'),
            'BRANCH_NAME'  => $request->input('BRANCH_NAME'),
            'AC_NO'        => $request->input('AC_NO'),
            'BNK_MOB_NO'   => $request->input('BNK_MOB_NO'),
            'DESIGNATION'  => $request->input('DESIGNATION'),
            'ACTIVE_FLG'   => $request->input('ACTIVE_FLG'),
            'UPDATED_BY' => auth()->user()->id,
            'UPDATED_AT' => date('Y-m-d h:i:s'),
        ]);
    }
    // add celebrity page
    public static function updateCelebrityPage($request,$registrationId){
        return DB::table('sf_celebrity_page')->where('CELEBRITY_ID',$registrationId)->update([
            'PERSONAL_OPINION'  => $request->input('PERSONAL_OPINION'),
            'ABOUT_OUR_SERVICE' => $request->input('ABOUT_OUR_SERVICE'),
            'CAMPAIGN_TAGLINE'  => $request->input('CAMPAIGN_TAGLINE'),
            'UPDATED_BY' => auth()->user()->id,
            'UPDATED_AT' => date('Y-m-d h:i:s'),
        ]);

    }
    // delete celebrity
    public static function deleteMemberInfo($id,$celebrityPageId){

        $imageDelete = DB::table('sf_celebrity_img')->where('CELEBRITYPAGE_ID', $celebrityPageId)->delete();
        if($imageDelete){
           $pageDelete =  DB::table('sf_celebrity_page')->where('CELEBRITY_ID', $id)->delete();
        }
        if($pageDelete){
            $mediaDelete = DB::table('sf_media_info')->where('CELEBRITY_ID', $id)->delete();
        }
        if($mediaDelete){
            return DB::table('sf_celebrity_reg')->where('CELEBRITY_ID', $id)->delete();
        }
    }

}
