<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;

class GoodsReceive extends Model
{
    public static function goods(){
        return DB::table('sf_goods_receive')
            ->select('sf_goods_receive.*', 'sf_product_info.PROD_NAME','sc_lkpdata.LDATA_NAME')
            ->leftJoin('sf_product_info', 'sf_goods_receive.PRODUCT_ID','=','sf_product_info.PRODUCT_ID')
            ->leftJoin('sc_lkpdata', 'sf_goods_receive.PACK_TYPE_ID','=','sc_lkpdata.LKP_DATAID')
            ->where('sf_goods_receive.ACTIVE_FLG', '=', 0)
            ->get();
    }
    public static function insert($data){
        return DB::table('sf_goods_receive')->insert($data);
    }
    public static function good($id){
        return DB::table('sf_goods_receive')->where('GOODS_RCV_ID', $id)->first();
    }
    public static function updateGoods($data, $id){
        return DB::table('sf_goods_receive')->where('GOODS_RCV_ID', $id)->update($data);
    }
    public static function verifyGoods($data, $id){
        return DB::table('sf_goods_receive')->where('GOODS_RCV_ID', $id)->update($data);
    }
    public static function deleteGoods($id){
        return DB::table('sf_goods_receive')->where('GOODS_RCV_ID', $id)->delete();
    }

}
