<?php

namespace App\Http\Controllers;

use App\AdminCustomer;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;

class AdminCustomerController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $header = [
            'createUrl'=>'admin-customers/create',
            'modalSize'=>'modal-lg',
            'title'=>'Create New Customer',
        ];
        $customers = AdminCustomer::customers();
        return view('admin.layouts.customersInfo.customer.index', compact('customers', 'header'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('admin.layouts.customersInfo.customer.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $data = array(
            'USERNAME'      => $request->input('USERNAME'),
            'EMAIL'         => $request->input('EMAIL'),
            'FIRST_NAME'    => $request->input('FIRST_NAME'),
            'LAST_NAME'     => $request->input('LAST_NAME'),
            'ADDRESS'       => $request->input('ADDRESS'),
            'GENDER'        => $request->input('GENDER'),
            'CONTACT'       => $request->input('CONTACT'),
            'PASSWORD'      => Hash::make($request->input('PASSWORD')),
            'ACTIVE_FLG'    => $request->input('ACTIVE_FLG'),
            'CREATED_BY'    => auth()->user()->id,
            'CREATED_AT'    => date('Y-m-d h:i:s'),
        );
        //$this->pr($data);
        $insert = AdminCustomer::insert($data);
        if ($insert){
            return redirect('admin-customers')->with('success', 'Customer created successfully');
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\AdminCustomer  $adminCustomer
     * @return \Illuminate\Http\Response
     */
    public function show(AdminCustomer $adminCustomer)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\AdminCustomer  $adminCustomer
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $customer = AdminCustomer::customer($id);
        return view('admin.layouts.customersInfo.customer.edit', compact('customer'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\AdminCustomer  $adminCustomer
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $data = array(
            //'USERNAME'      => $request->input('USERNAME'),
            //'EMAIL'         => $request->input('EMAIL'),
            'FIRST_NAME'    => $request->input('FIRST_NAME'),
            'LAST_NAME'     => $request->input('LAST_NAME'),
            'ADDRESS'       => $request->input('ADDRESS'),
            'CONTACT'       => $request->input('CONTACT'),
            'GENDER'        => $request->input('GENDER'),
            'ACTIVE_FLG'    => $request->input('ACTIVE_FLG'),
            'UPDATED_BY'    => auth()->user()->id,
            'UPDATED_AT'    => date('Y-m-d h:i:s'),
        );
        if(!empty($request->input('PASSWORD'))){
            $data['PASSWORD' ] = Hash::make($request->input('PASSWORD'));
        }
        //$this->pr($data);
        $update = AdminCustomer::updateCustomer($data, $id);
        if ($update){
            return redirect('admin-customers')->with('success', 'Customer updated successfully');
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\AdminCustomer  $adminCustomer
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $delete = AdminCustomer::deleteCustomer($id);
        if($delete){
            echo json_encode([
                'type' => 'tr',
                'id' => $id,
                'flag' => true,
                'message' => 'Customer Deleted Successfully',
            ]);
        }else{
            echo json_encode([
                'message' => 'Error Found Here!',
            ]);
        }
    }
}
