<?php

namespace App\Http\Controllers;

use App\Baselink;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class BaselinkController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $header = [
            'createUrl'=>'base-links/create',
            'modalSize'=>'modal-lg',
            'title'=>'Create Base Link',
        ];

        $baseLinks = Baselink::all();

        return view('admin.layouts.accessControl.baseLinks.index', compact('header', 'baseLinks'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $modules = Baselink::moduleLinks();

//        dd($modules);

        return view('admin.layouts.accessControl.baseLinks.create', compact('modules'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {

        $data = array(
            'BLNK_ENAME' => $request->input('linkName'),
            'BLNK_LNAME' => $request->input('linkNameBangla'),
            'PTGBLNK_ID' => $request->input('parentModuleId'),
            'ASTATUS_FG' => $request->input('activeStatus'),
            'USERDSL_NO' => $request->input('userDefineCode'),
            'ROUTE_URLS' => $request->input('routeUrl'),
            'METHODTYPE' => $request->input('methodType'),
            'BLINK_CODE' => $request->input('moduleCode'),
            'MAPTYPE_ID' => $request->input('menuType'),
            'CONTROLLER' => $request->input('controllerMethod'),
            'CREATED_BY' => auth()->user()->id,
            //'CREATED_AT' => date('Y-m-d h:i:s')
        );

        Baselink::create($data);

        return redirect('base-links')->with('success','Base Link Created Successfully.');

    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $modules = Baselink::moduleLinks();
        $baseLink = Baselink::where('BASELNK_ID', $id)->first();
//        dd($baseLink);
        return view('admin.layouts.accessControl.baseLinks.edit', compact('modules', 'baseLink'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $data = array(
            'BLNK_ENAME' => $request->input('linkName'),
            'BLNK_LNAME' => $request->input('linkNameBangla'),
            'PTGBLNK_ID' => $request->input('parentModuleId'),
            'ASTATUS_FG' => $request->input('activeStatus'),
            'USERDSL_NO' => $request->input('userDefineCode'),
            'ROUTE_URLS' => $request->input('routeUrl'),
            'METHODTYPE' => $request->input('methodType'),
            'BLINK_CODE' => $request->input('moduleCode'),
            'MAPTYPE_ID' => $request->input('menuType'),
            'CONTROLLER' => $request->input('controllerMethod'),
            'UPDATED_BY' => auth()->user()->id,
            //'UPDATED_AT' => date('Y-m-d h:i:s'),
        );

        $update = DB::table('sc_baselnk')->where('BASELNK_ID', $id)->update($data);
//        dd($update);
        if($update){
            return redirect('base-links')->with('success','Base Link Updated Successfully.');
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $delete = Baselink::deleteRow($id);
        if($delete){
            echo json_encode([
                'flag' => true,
                'message' => 'Base Link Deleted Successfully',
            ]);
        } else{
            echo json_encode([
                'message' => 'Error Found Here!',
            ]);
        }
    }
}
