<?php

namespace App\Http\Controllers;

use App\Cart;
use App\Customer;
use App\LookupGroup;
use App\Order;
use App\ProductInfo;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\DB;

class CartController extends Controller
{
    public function getCustomerId(){
        return Session::get('customerId');
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $carts = Cart::carts($this->getCustomerId());
//        $this->pr($carts);
        return view('public.includes.cart', compact('carts'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $status = false;
        $productId = $request->input('product_id');
        $customerId = $this->getCustomerId();
        $hasProduct = Cart::hasProduct($customerId, $productId);
        if(!$hasProduct) {
            $data = array(
                'CUSTOMER_ID' => $this->getCustomerId(),
                'PRODUCT_ID' => $request->input('product_id'),
                'PACK_TYPE_ID' => $request->input('data_pack_id'),
                'IS_BOX_ORDER' => $request->input('isOrderBox'),
                'QUANTITY' => $request->input('product_quantity'),
                'DISCOUNT' => $request->input('Product_discount'),
                'PRICE' => $request->input('product_price'),
            );

            $taskComplete = Cart::create($data);
        } else{
            $data = array(
                'QUANTITY' => $hasProduct->QUANTITY+1
            );
            $taskComplete = DB::table('sf_carts')
                ->where('CUSTOMER_ID', $customerId)
                ->where('PRODUCT_ID', $productId)
                ->update($data);
        }
        if($taskComplete){
            $status = true;
        }
        echo  $status;
        die();
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Cart  $card
     * @return \Illuminate\Http\Response
     */
    public function show($customerId)
    {
        $uoms = LookupGroup::getUnityOfMeasurements($this->unityOfMeasurementId);
        $carts = Cart::carts($this->getCustomerId());
        $customer = Customer::customer($this->getCustomerId());
//        dd($uoms);
        return view('public.layouts.cart', compact('carts','customer', 'uoms'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Cart  $card
     * @return \Illuminate\Http\Response
     */
    public function edit(Cart $card)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Cart  $card
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $productId)
    {
        $status = false;
        $customerId = $this->getCustomerId();
        $quantity = $request->input('quantity');
        $price = $request->input('price');

        $data = array(
            'QUANTITY' => $quantity,
            'PRICE' => $quantity*$price,
        );

        $taskComplete = DB::table('sf_carts')
            ->where('CUSTOMER_ID', $customerId)
            ->where('PRODUCT_ID', $productId)
            ->update($data);

        if($taskComplete){
            $status = true;
        }
        echo $status;
        die();
    }


    public function updateIsBoxOrder(Request $request, $productId)
    {
        $status = false;
        $customerId = $this->getCustomerId();
        $quantity = $request->input('quantity');
        $isBoxOrder = $request->input('isBoxOrder');
        $product = ProductInfo::product($productId);
        $price = $isBoxOrder==1? $product->BOX_PRICE : $product->UNIT_PRICE;
        $price = $price-(($price*$product->DISC_PCT)/100);

        $data = array(
            'QUANTITY' => $quantity,
            'IS_BOX_ORDER' => $isBoxOrder,
            'PRICE' => $quantity*$price,
        );

        $taskComplete = DB::table('sf_carts')
            ->where('CUSTOMER_ID', $customerId)
            ->where('PRODUCT_ID', $productId)
            ->update($data);

        if($taskComplete){
            $status = true;
        }
        echo $status;
        die();
    }



    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Cart  $card
     * @return \Illuminate\Http\Response
     */
    public function destroy($productId)
    {
        return Cart::deleteRow($this->getCustomerId(), $productId);
    }
    //------------------order submit---------------------
    public function orderSubmit(Request $request){
        $celebrity_id = null;
        $orderPlace = $request->input('orderPlace');
        $contactNo = $request->input('contactNo');
        $deliveryDate = $request->input('deliveryDate');
        if(!empty(Session::get('cel_token'))) $celebrity_id = Session::get('celebrity_id');

        $status = false;
        $carts = Cart::cartDetails($this->getCustomerId());
        $customer = Customer::customer($this->getCustomerId());
//        $this->pr($carts);
        $orderMst = array(
            'CUSTOMER_ID' => $customer->CUSTOMER_ID,
            'CELEBRITY_ID' => $celebrity_id,
            'ORDER_PLACE' => $orderPlace,
            'CONTACT_NO'      => $contactNo,
            'DELIVERY_DATE'      => $this->dateFormat($deliveryDate),
            'CREATED_BY'    => $customer->CUSTOMER_ID,
            'CREATED_AT'    => date('Y-m-d h:i:s'),
        );

        $orderMstId = Order::insertMst($orderMst);
        if($orderMst){
            $orderChd = array();
            foreach ($carts as $cart){
                $orderChd[] = array(
                    'ORDERMST_ID' => $orderMstId,
                    'PRODUCT_ID' => $cart->PRODUCT_ID,
                    'PACK_TYPE_ID' => $cart->PACK_TYPE_ID,
                    'IS_BOX_ORDER' => $cart->IS_BOX_ORDER,
                    'QUANTITY' => $cart->QUANTITY,
                    'PRICE' => $cart->PRICE,
                );
            }
            $status = Order::insertChd($orderChd);
        }

        if ($status){
            Cart::deleteByCustomerId($this->getCustomerId());
            return redirect('/customer-payment/'.$this->getCustomerId()); //->with('success', 'Order submitted Successfully');
        }


    }
}
