<?php

namespace App\Http\Controllers;

use App\CelOrderInfo;
use App\CelebrityRegistration;
use App\Order;
use Illuminate\Http\Request;

class CelOrderInfoController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $orders = Order::orders();
        $celebrities = CelebrityRegistration::celebrities();
        return view('admin.layouts.celebritiesInfo.celebritiesOrderInfo.index', compact('orders','celebrities'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\CelebrityScore  $celebrityScore
     * @return \Illuminate\Http\Response
     */
    public function show(CelebrityScore $celebrityScore)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\CelebrityScore  $celebrityScore
     * @return \Illuminate\Http\Response
     */
    public function edit(CelebrityScore $celebrityScore)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\CelebrityScore  $celebrityScore
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, CelebrityScore $celebrityScore)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\CelebrityScore  $celebrityScore
     * @return \Illuminate\Http\Response
     */
    public function destroy(CelebrityScore $celebrityScore)
    {
        //
    }

    public function searchCelebrityOrders(Request $request){
        $celebrityId = $request->input('celebrityId');
        $orderTypeId = $request->input('orderTypeId');
//        echo $celebrityId; exit();
        $orders = CelOrderInfo::orders($celebrityId, $orderTypeId);
        return view('admin.layouts.celebritiesInfo.celebritiesOrderInfo.searchByCelebrity', compact('orders'));
    }
}
