<?php

namespace App\Http\Controllers;

use App\CelebrityProfile;
use App\ProductInfo;
use Illuminate\Support\Facades\Session;
use Illuminate\Http\Request;

class CelebrityProfileController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {

    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\CelebrityProfile  $celebrityProfile
     * @return \Illuminate\Http\Response
     */
    public function show(Request $request, $id, $productsId=null)
    {
        $cel_fb_token = $request->input('fbclid');
        if(!empty($productsId)){
            $productId = explode(',', $productsId);
            $products = ProductInfo::allProducts()->whereIn('PRODUCT_ID', $productId);
        } else{
            $products = ProductInfo::getNewArrivals();
        }

        Session::put([
            'celebrity_id' => $id,
            'cel_token' => $cel_fb_token,
        ]);

        $celebrity   = CelebrityProfile::getCelebrityInfo($id);
        $celebrityMedia = CelebrityProfile::getMediaInfo($id);

        //$this->pr($celebrityMedia);
        return view('public.layouts.celebrityProfile', compact('celebrity','products', 'celebrityMedia'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\CelebrityProfile  $celebrityProfile
     * @return \Illuminate\Http\Response
     */
    public function edit(CelebrityProfile $celebrityProfile)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\CelebrityProfile  $celebrityProfile
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, CelebrityProfile $celebrityProfile)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\CelebrityProfile  $celebrityProfile
     * @return \Illuminate\Http\Response
     */
    public function destroy(CelebrityProfile $celebrityProfile)
    {
        //
    }
}
