<?php

namespace App\Http\Controllers;
use App\LookupGroup;
use App\CelebrityRegistration;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;

class CelebrityRegistrationController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $header = [
            'createUrl'=>'celebrities-registration/create',
            'modalSize'=>'modal-lg',
            'title'=>'Create New Member',
        ];
        $members = CelebrityRegistration::celebrities();
        return view('admin.layouts.celebritiesInfo.celebritiesRegistration.index', compact('header','members'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $countries  = LookupGroup::countryList($this->countryId);
        $province = LookupGroup::provinceList($this->provinceId);
        $districts = LookupGroup::districtList($this->districtId);
        $regions   = LookupGroup::regionList($this->regionId);
        $banks     = LookupGroup::bankList($this->bankId);
        return view('admin.layouts.celebritiesInfo.celebritiesRegistration.create', compact('countries','province','districts','regions','banks'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
       // general info
        $celebrityId = CelebrityRegistration::addCelebrity($request);
        // media info
        $mediaName  = $request->input('MEDIA_NAME');
        $groupName  = $request->input('MEDIA_GROUP');
        $aboutGroup = $request->input('ABOUT_GROUP');
        $follower   = $request->input('FOLLOWER');
        $groupLink  = $request->input('MEDIA_LINK');
        $mediaLength = count($mediaName);
        for ($i=0;$i<$mediaLength;$i++){
            $mediaInfo = DB::table('sf_media_info')->insert([
                'CELEBRITY_ID'  => $celebrityId,
                'MEDIA_NAME'  => $mediaName[$i],
                'MEDIA_GROUP' => $groupName[$i],
                'ABOUT_GROUP' => $aboutGroup[$i],
                'FOLLOWER'    => $follower[$i],
                'MEDIA_LINK'  => $groupLink[$i],
                'CREATED_BY'  => auth()->user()->id,
                'CREATED_AT'  => date('Y-m-d h:i:s'),
            ]);
        }
        // personalized info
        $celebrityPageId = CelebrityRegistration::addCelebrityPage($request,$celebrityId);
        // page owner image
        if (!empty($request->file('photo'))) {
            $files = $request->file('photo'); //echo count($files);exit();
            foreach ($files as $file) {
                // file with extension
                $fileWithExt = $file->getClientOriginalName();
                // file name
                $filename = pathinfo($fileWithExt, PATHINFO_FILENAME);
                // get file extension
                $extension = $file->getClientOriginalExtension();
                // create unique file name
                $celebrityImage = $filename . '_' . time() . '.' . $extension;
                // move to destination
                $destination = base_path() . '/public/uploads/registration';
                $file->move($destination, $celebrityImage);
                // upload in table
                $insertImage = array(
                    'CELEBRITYPAGE_ID' => $celebrityPageId,
                    'IMAGE_LINK' => $celebrityImage,
                    'CREATED_BY' => auth()->user()->id,
                    'CREATED_AT' => date('Y-m-d h:i:s')
                );
                $imgInsert = CelebrityRegistration::addMemberImg($insertImage);
            }
        }
        if($celebrityId){
            return redirect('/celebrities-registration')->with('success', 'Member has been registered successfully');
        }



    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $memberForm = CelebrityRegistration::getMemberInfo($id);
        $mediaInfo = CelebrityRegistration::getMediaInfo($id);
        $pageId = DB::table('sf_celebrity_page')->where('CELEBRITY_ID',$id)->first();
        $pageOwnerImage = CelebrityRegistration::getMediaImg($pageId->CELEBRITYPAGE_ID);
        $profileImage = CelebrityRegistration::getProfileImg($pageId->CELEBRITYPAGE_ID);
        $lookUpData = CelebrityRegistration::getLookUpData($id); //$this->pr($lookUpData);
        return view('admin.layouts.celebritiesInfo.celebritiesRegistration.show', compact('memberForm','mediaInfo','pageOwnerImage','profileImage','lookUpData'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $countries  = LookupGroup::countryList($this->countryId);
        $province = LookupGroup::provinceList($this->provinceId);
        $districts = LookupGroup::districtList($this->districtId);
        $regions   = LookupGroup::regionList($this->regionId);
        $banks     = LookupGroup::bankList($this->bankId);
        $editData = CelebrityRegistration::editMemberInfo($id);
        $editMemberForm = CelebrityRegistration::getMemberInfo($id);
        $editMediaInfo = CelebrityRegistration::getMediaInfo($id);
        $pageId = DB::table('sf_celebrity_page')->where('CELEBRITY_ID',$id)->first();
        $profileImage = CelebrityRegistration::getProfileImg($pageId->CELEBRITYPAGE_ID);
        $editPageOwnerImage = CelebrityRegistration::getMediaImg($pageId->CELEBRITYPAGE_ID);
        //$this->pr($editMemberForm);
        return view('admin.layouts.celebritiesInfo.celebritiesRegistration.edit', compact('editMemberForm','editMediaInfo','countries','province','districts','regions','banks','editData','profileImage'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        // general info update
        $celebrityId = CelebrityRegistration::updateCelebrity($request,$id);
        // media info update
        $mediaName  = $request->input('MEDIA_NAME');
        $groupName  = $request->input('MEDIA_GROUP');
        $aboutGroup = $request->input('ABOUT_GROUP');
        $follower   = $request->input('FOLLOWER');
        $groupLink  = $request->input('MEDIA_LINK');
        $deleteMediaInfo = DB::table('sf_media_info')->where('CELEBRITY_ID',$id)->delete();
        $mediaLength = count($mediaName);
        if($deleteMediaInfo) {
            for ($i = 0; $i < $mediaLength; $i++) {
                $mediaInfo = DB::table('sf_media_info')->insert([
                    'CELEBRITY_ID' => $id,
                    'MEDIA_NAME' => $mediaName[$i],
                    'MEDIA_GROUP' => $groupName[$i],
                    'ABOUT_GROUP' => $aboutGroup[$i],
                    'FOLLOWER' => $follower[$i],
                    'MEDIA_LINK' => $groupLink[$i],
                    'UPDATED_BY' => auth()->user()->id,
                    'UPDATED_AT' => date('Y-m-d h:i:s'),
                ]);
            }
        }
        // page info update
        $updateCelebrityPage = CelebrityRegistration::updateCelebrityPage($request,$id);
        // image updated
        // celebrity if getting
        $celebrity = DB::table('sf_celebrity_page')->where('CELEBRITY_ID',$id)->first();
        $celebrityPageId = $celebrity->CELEBRITYPAGE_ID;
        if (!empty($request->file('photo'))) {
            $deleteImage = DB::table('sf_celebrity_img')->where('CELEBRITYPAGE_ID',$celebrityPageId)->delete();
            $files = $request->file('photo'); //echo count($files);exit();
            foreach ($files as $file) {
                // file with extension
                $fileWithExt = $file->getClientOriginalName();
                // file name
                $filename = pathinfo($fileWithExt, PATHINFO_FILENAME);
                // get file extension
                $extension = $file->getClientOriginalExtension();
                // create unique file name
                $celebrityImage = $filename . '_' . time() . '.' . $extension;
                // move to destination
                $destination = base_path() . '/public/uploads/registration';
                $file->move($destination, $celebrityImage);
                // upload in table
                $insertImage = array(
                    'CELEBRITYPAGE_ID' => $celebrityPageId,
                    'IMAGE_LINK' => $celebrityImage,
                    'UPDATED_BY' => auth()->user()->id,
                    'UPDATED_AT' => date('Y-m-d h:i:s'),
                );
                $imgInsert = CelebrityRegistration::addMemberImg($insertImage);

            }
        }


        return redirect('/celebrities-registration')->with('success', 'Member Information has been updated successfully');

    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $celebrity = DB::table('sf_celebrity_page')->where('CELEBRITY_ID',$id)->first();
        $celebrityPageId = $celebrity->CELEBRITYPAGE_ID;
        $delete = CelebrityRegistration::deleteMemberInfo($id,$celebrityPageId);
        if($delete){
            echo json_encode([
                'type' => 'tr',
                'id' => $id,
                'flag' => true,
                'message' => 'Celebrity Deleted Successfully',
            ]);
        }else{
            echo json_encode([
                'message' => 'Error Found Here!',
            ]);
        }
    }
    // delete media page
    public function deleteMediaPage($id){
        return DB::table('sf_media_info')->where('MEDIAINFO_ID',$id)->delete();
    }
    public function pr($data){
        echo '<pre>';
        print_r($data);
        exit();
    }
}
