<?php

namespace App\Http\Controllers;

use App\Customer;
use App\LookupGroup;
use App\Order;
use App\TermCondition;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Redirect;

class CustomerController extends Controller
{
    public function getCustomerId(){
        return Session::get('customerId');
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $data = array(
            'USERNAME' => $request->input('USERNAME'),
            //'FIRST_NAME' => $request->input('FIRST_NAME'),
            //'LAST_NAME'  => $request->input('LAST_NAME'),
            //'GENDER'     => $request->input('GENDER'),
            //'ADDRESS'    => $request->input('ADDRESS'),
            'CONTACT'    => $request->input('CONTACT'),
            'EMAIL'      => $request->input('EMAIL'),
            'PASSWORD'   => Hash::make($request->input('PASSWORD')),
        );
        $customerId = Customer::addNewCustomer($data);
        if($customerId){
            Session::put([
                'customerId' => $customerId,
                'username' => $request->input('USERNAME'),
                'contact' => $request->input('CONTACT'),
                'email' => $request->input('EMAIL'),
                'success' => 'Logged in successfully.',
            ]);
            return redirect('/');
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Customer  $customerLogin
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $customer = Customer::customer($id);
        return view('public.layouts.customer.show', compact('customer'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Customer  $customerLogin
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $customer = Customer::customer($id);
        return view('public.layouts.customer.edit', compact('customer'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Customer  $customerLogin
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        if (!empty($request->file('photo'))) {
            $file = $request->file('photo');
            // file with extension
            $fileWithExt = $file->getClientOriginalName();
            // file name
            $filename = pathinfo($fileWithExt, PATHINFO_FILENAME);
            // get file extension
            $extension = $file->getClientOriginalExtension();
            // create unique file name
            $profilePhoto = $filename . '_' . time() . '.' . $extension;
            // move to destination
            $destination = base_path() . '/public/uploads/customers';
            $file->move($destination, $profilePhoto);
        }
        $data = array(
            'FIRST_NAME' => $request->input('FIRST_NAME'),
            'LAST_NAME'  => $request->input('LAST_NAME'),
            'GENDER'     => $request->input('GENDER'),
            'ADDRESS'    => $request->input('ADDRESS'),
            'CONTACT'    => $request->input('CONTACT'),
        );
        if (!empty($request->file('photo'))) {
            $data['PROFILE_PHOTO'] = $profilePhoto;
        }
        $update = Customer::updateCustomer($data, $id);
        if ($update){
            return redirect('/customer-profile/'.$id)->with('success', 'Profile has been updated successfully');
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Customer  $customerLogin
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }

    public function login(Request $request){
        $username = $request->input('username');
        $password = $request->input('password');
        $checkUsername = DB::table('sf_customers')->where('USERNAME',$username)->first();
        if($checkUsername){
            $checkPassword = Hash::check($password, $checkUsername->PASSWORD);
            if ($checkPassword){
                Session::put([
                    'customerId' => $checkUsername->CUSTOMER_ID,
                    'username' => $checkUsername->USERNAME,
                    'contact' => $checkUsername->CONTACT,
                    'email' => $checkUsername->EMAIL,
                    'success' => 'Logged in successfully.',
                ]);
                return redirect::back();
            }else{
                Session::put('error','Invalid Username or Password. Please Try Again.');
            }
        }else{
            Session::put('error','Invalid Username or Password. Please Try Again.');
        }
        return redirect('/');
    }

    public function customerOrders($customerId){
        $orders = Order::customerOrders($customerId);
        $customer = Customer::customer($customerId);
        return view('public.layouts.customer.orders', compact('orders','customer','ordersDetails'));
    }

    public function customerOrderDetails($orderId){
        $ordersDetails = Order::customerOrdersDetails($orderId);
        return view('public.layouts.customer.orderDetails', compact('orders','customer','ordersDetails'));
    }


    public function customerPayment($customerId){
        $order = Order::orderByCustomer($customerId);
        $customer = Customer::customer($customerId);
        $paymentTypes = LookupGroup::paymentTypes($this->paymentTypeId);
        $codPaymentTermsConditions = TermCondition::codTermsConditions($this->codPaymentId);
        $onlinePaymentTermsConditions = TermCondition::onlineTermsConditions($this->onlinePaymentId);
        return view('public/layouts/customer/payment', compact('order', 'customer', 'paymentTypes','codPaymentTermsConditions','onlinePaymentTermsConditions'));
    }

    public function customerPaymentStore(Request $request, $orderId){
        $paymentType = $request->input('paymentType');
        $isAgree = $request->input('isAgree');
        if(empty($isAgree)) {
            return redirect('/customer-payment/' . $this->getCustomerId()); //->with('error', 'Required Agreements with terms and conditions');
        }

        if (!empty($request->file('transaction_doc'))) {
            $file = $request->file('transaction_doc');
            // file with extension
            $fileWithExt = $file->getClientOriginalName();
            // file name
            $filename = pathinfo($fileWithExt, PATHINFO_FILENAME);
            // get file extension
            $extension = $file->getClientOriginalExtension();
            // create unique file name
            $docName = $filename . '_' . time() . '.' . $extension;
            // move to destination
            $destination = base_path() . '/public/uploads/transaction_doc';
            $file->move($destination, $docName);
        }

        Order::updatePaymentStatus($orderId, $paymentType);
        return redirect('/customer-payment/'.$this->getCustomerId()); //->with('success', 'Payment submitted Successfully');


    }


}
