<?php

namespace App\Http\Controllers;

use App\GoodsReceive;
use App\ItemStock;
use App\ProductInfo;
use Illuminate\Http\Request;
use App\LookupGroup;

class GoodsReceiveController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $header = [
            'createUrl'=>'goods-receive/create',
            'modalSize'=>'modal-lg',
            'title'=>'Receive New Goods',
        ];
        $goods = GoodsReceive::goods();
        return view('admin.layouts.goodsReceive.index', compact('goods', 'header'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $products = ProductInfo::products();
        $uoms = LookupGroup::getUnityOfMeasurements($this->unityOfMeasurementId);
        return view('admin.layouts.goodsReceive.create', compact('uoms', 'products'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $data = array(
            'PRODUCT_ID'  => $request->input('PRODUCT_ID'),
            'PACK_TYPE_ID'=> $request->input('PACK_TYPE_ID'),
            'IS_BOX'      => $request->input('IS_BOX'),
            'QUANTITY'    => $request->input('QUANTITY'),
            'CREATED_BY'  => auth()->user()->id,
            'CREATED_AT'  => date('Y-m-d h:i:s'),
        );
        //$this->pr($data);
        $insert = GoodsReceive::insert($data);
        if ($insert){
            return redirect('goods-receive')->with('success', 'Product received successfully');
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\GoodsReceiveController  $goodsReceiveController
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\GoodsReceiveController  $goodsReceiveController
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $products = ProductInfo::products();
        $uoms = LookupGroup::getUnityOfMeasurements($this->unityOfMeasurementId);
        $good = GoodsReceive::good($id);
        return view('admin.layouts.goodsReceive.edit', compact('uoms', 'products', 'good'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\GoodsReceiveController  $goodsReceiveController
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $data = array(
            'PRODUCT_ID'  => $request->input('PRODUCT_ID'),
            'PACK_TYPE_ID'=> $request->input('PACK_TYPE_ID'),
            'IS_BOX'      => $request->input('IS_BOX'),
            'QUANTITY'    => $request->input('QUANTITY'),
            'UPDATED_BY'  => auth()->user()->id,
            'UPDATED_AT'  => date('Y-m-d h:i:s'),
        );
        //$this->pr($data);
        $updateGoods = GoodsReceive::updateGoods($data, $id);
        if ($updateGoods){
            return redirect('goods-receive')->with('success', 'Product updated successfully');
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\GoodsReceiveController  $goodsReceiveController
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $delete = GoodsReceive::deleteGoods($id);
        if($delete){
            echo json_encode([
                'type' => 'tr',
                'id' => $id,
                'flag' => true,
                'message' => 'Product Deleted Successfully',
            ]);
        }else{
            echo json_encode([
                'message' => 'Error Found Here!',
            ]);
        }
    }
    public function verifyGoods(Request $request){
        $goodsId = $request->input('goodsId');
        $good = GoodsReceive::good($goodsId);
        $productPrice = ProductInfo::product($good->PRODUCT_ID);
        if($good->IS_BOX===1){
            $price = $good->QUANTITY * $productPrice->BOX_PRICE;
        }else{
            $price = $good->QUANTITY * $productPrice->UNIT_PRICE;
        }
        $data = array('ACTIVE_FLG' => 1);
        $stock = array(
            'TRAN_ID'     => $goodsId,
            'TRAN_TYPE'   => 'I',
            'PRODUCT_ID'  => $good->PRODUCT_ID,
            'PACK_TYPE_ID'=> $good->PACK_TYPE_ID,
            'IS_BOX'      => $good->IS_BOX,
            'QUANTITY'    => $good->QUANTITY,
            //'PRICE'       => $price,
            'CREATED_BY'  => auth()->user()->id,
            'CREATED_AT'  => date('Y-m-d h:i:s'),
        );
        //$this->pr($stock);
        $verifyGoods = GoodsReceive::verifyGoods($data, $goodsId);
        $insert = ItemStock::insert($stock);
    }
}
