<?php

namespace App\Http\Controllers;

use App\LookupData;
use Illuminate\Http\Request;

class LookupDataController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //return view('admin.setup.baseSetup.lookupData.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $data = array(
            'LDATA_NAME' => $request->input('LDATA_NAME'),
            'LKP_GRP_ID' => $request->input('LKP_GRP_ID'),
            //'CHARLOOKUP' => $request->input('CHARLOOKUP'),
            'USERDSL_NO' => $request->input('USERDSL_NO'),
            'ASTATUS_FG' => $request->input('ASTATUS_FG'),
            'CREATED_BY' => auth()->user()->id,
            'CREATED_AT' => date('Y-m-d h:i:s'),
        );
        $lookupData = LookupData::insertLookupData($data);
        if($lookupData){
            return redirect('/lookup-group-setup')->with('success','Lookup Data has been added successfully');
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\LookupData  $lookupData
     * @return \Illuminate\Http\Response
     */
    public function show(LookupData $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\LookupData  $lookupData
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $editData = LookupData::getLookupData($id);
        return view('admin.layouts.accessControl.lookupSetup.lookupData.edit', compact('editData'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\LookupData  $lookupData
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {

        $lookupDataUpdate = LookupData::updateLookupData($request,$id);
        if($lookupDataUpdate){
            return redirect('/lookup-group-setup')->with('success','Lookup Data has been updated successfully');
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\LookupData  $lookupData
     * @return \Illuminate\Http\Response
     */
    public function destroy($lookupData)
    {
        $id = $lookupData;
        $delete = LookupData::deleteLookupData($id);
        if($delete){
            echo json_encode([
                'type' => 'tr',
                'id' => $id,
                'flag' => true,
                'message' => 'Lookup Data Deleted Successfully',
            ]);
        } else{
            echo json_encode([
                'message' => 'Error Found Here!',
            ]);
        }
    }

    public function addLookupData($id){
        $lookupGroupId = $id;
        return view('admin.layouts.accessControl.lookupSetup.lookupData.create',compact('lookupGroupId'));
    }
}
