<?php

namespace App\Http\Controllers;

use App\LookupGroup;
use Illuminate\Http\Request;
use DB;

class LookupGroupController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $header = [
            'createUrl'=>'lookup-group-setup/create',
            'modalSize'=>'modal-md',
            'title'=>'Create Group',
        ];
        $lookupGroups = DB::table('sc_lkp_grp')->where('ASTATUS_FG',1)->get();
        $lookupData = DB::table('sc_lkpdata')->where('ASTATUS_FG',1)->get();
        return view('admin.layouts.accessControl.lookupSetup.lookupGroup.index', compact('header','lookupGroups', 'lookupData'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('admin.layouts.accessControl.lookupSetup.lookupGroup.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {

        $data = array(
            'LKPGRPNAME' => $request->input('LKPGRPNAME'),
            'UDLKPGRPNO' => $request->input('UDLKPGRPNO'),
            'ASTATUS_FG' => $request->input('ASTATUS_FG'),
            'CREATED_BY' => auth()->user()->id,
            'CREATED_AT' => date('Y-m-d h:i:s'),
        );
        $baseGroup = LookupGroup::insertBaseGroup($data);
        if($baseGroup){
            return redirect('/lookup-group-setup')->with('success','Lookup Group has been added successfully');
        }

    }

    /**
     * Display the specified resource.
     *
     * @param  \App\LookupGroup  $baseSetup
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\LookupGroup  $baseSetup
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $editData = LookupGroup::getLookupGroup($id);
        return view('admin.layouts.accessControl.lookupSetup.lookupGroup.edit', compact('editData'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\LookupGroup  $baseSetup
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $lookupGroupUpdate = LookupGroup::updateLookupGroup($request,$id);
        if($lookupGroupUpdate){
            return redirect('/lookup-group-setup')->with('success','Lookup Group has been updated successfully');
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\LookupGroup  $baseSetup
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {

        $delete = LookupGroup::deleteLookupGroup($id);
        if($delete){
            echo json_encode([
                'type' => 'tr',
                'id' => $id,
                'flag' => true,
                'message' => 'Lookup Gropup Deleted Successfully',
            ]);
        } else{
            echo json_encode([
                'message' => 'Error Found Here!',
            ]);
        }

    }

    public function pr($data){
        echo '<pre>';
        print_r($data);
        exit();
    }
}
