<?php

namespace App\Http\Controllers;

use App\Baselink;
use App\Module;
use App\ModuleAssign;
use App\UserGroup;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class ModuleAssignController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $userGroups = UserGroup::getUserGroups();

        return view('admin.layouts.accessControl.roleAssign.index', compact('userGroups'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $userGroupId = $request->input('userGroupId');
        $modules = Module::modules();
        $moduleLinks = ModuleAssign::moduleLinks($userGroupId);
//        $this->pr($moduleLinks);

        return view('admin.layouts.accessControl.roleAssign.view', compact('userGroupId', 'modules', 'moduleLinks'));
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\ModuleAssign  $roleAssign
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\ModuleAssign  $roleAssign
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        echo $id;
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\ModuleAssign  $roleAssign
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    public function handlePermission(Request $request, $userGroupId)
    {
        $moduleLinkId   = $request->input('moduleLinkId');
        $permissionType = $request->input('permissionType');
        $status = $request->input('status');

//        return array($moduleLinkId,$userGroupId,$permissionType,$status);
        // check moduleLink and groupLinkId
        $ifExist = DB::table('sc_grplink')
            ->where('MMNLINK_ID', $moduleLinkId)
            ->where('MNLAGRP_ID', $userGroupId)
            ->first();
//        echo json_encode($ifExist);

        if($ifExist){
            $data = array(
                $this->columnHandling($permissionType) => $status,
                'CREATED_BY' => auth()->user()->id,
                'CREATED_AT' => date('Y-m-d h:i:s')
            );

            DB::table('sc_grplink')
                ->where('GRPLINK_ID', $ifExist->GRPLINK_ID)
                ->where('MMNLINK_ID', $moduleLinkId)
                ->update($data);

        }else {
            $data = array(
                'MNLAGRP_ID' => $userGroupId,
                'MMNLINK_ID' => $moduleLinkId,
                'CRUDLAC_FG' => $this->columnHandling($permissionType) == 'CRUDLAC_FG' ? $status: 0,
                'CRUDLAR_FG' => $this->columnHandling($permissionType) == 'CRUDLAR_FG' ? $status: 0,
                'CRUDLAU_FG' => $this->columnHandling($permissionType) == 'CRUDLAU_FG' ? $status: 0,
                'CRUDLAD_FG' => $this->columnHandling($permissionType) == 'CRUDLAD_FG' ? $status: 0,
                'ASTATUS_FG' => $this->columnHandling($permissionType) == 'ASTATUS_FG' ? $status: 0,
                'CREATED_BY' => auth()->user()->id,
                //'CREATED_AT' => date('Y-m-d h:i:s')
            );
            //dd($data);
             ModuleAssign::create($data);
        }
        die();
    }

    public function columnHandling($type){
        if($type=='C'){
            return 'CRUDLAC_FG';
        } else if($type=='R'){
            return 'CRUDLAR_FG';
        } else if($type=='U'){
            return 'CRUDLAU_FG';
        } else if($type=='D'){
            return 'CRUDLAD_FG';
        } else if($type=='AS'){
            return 'ASTATUS_FG';
        }
    }



    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\ModuleAssign  $roleAssign
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
