<?php

namespace App\Http\Controllers;

use App\Module;
use App\Baselink;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class ModuleController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $header = [
            'createUrl'=>'modules/create',
            'modalSize'=>'modal-lg',
            'title'=>'Create New Module',
        ];
//        $modules = Module::where('PTGMLNK_ID', null)->where('ASTATUS_FG','1')->get();
        $modules = Module::where('ASTATUS_FG','1')->get();
        return view('admin.layouts.accessControl.modules.index', compact('modules','header'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $modules = Module::where('PTGMLNK_ID', null)->where('MNLNK_TYPE','M')->where('ASTATUS_FG','1')->get();
        $baseLinks = Baselink::where('ASTATUS_FG','1')->where('MAPTYPE_ID','M')->get();
        return view('admin.layouts.accessControl.modules.create', compact('modules','baseLinks'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $moduleId = Module::addNewModule($request);
        if($request->input('PTGMLNK_ID') == ''){
            $parentModuleID = null;
            $MODLINK_ID = $moduleId;
        }else{
            $parentModuleID = $request->input('PTGMLNK_ID');
            $MODLINK_ID = $parentModuleID;
        }
        $updateData = array(
                'PTGMLNK_ID' => $parentModuleID,
                'MODLINK_ID' => $MODLINK_ID,
        );
        //$this->pr($updateData);
        $data = DB::table('sc_mmnlink')->where('MMNLINK_ID', $moduleId)->update($updateData);
        if($data){
            return redirect('/modules')->with('success','Module has been created successfully');
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Module  $module
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Module  $module
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $module = Module::module($id);
        $modules = Module::where('PTGMLNK_ID', null)->where('ASTATUS_FG','1')->get();
        $baseLinks = Baselink::where('ASTATUS_FG','1')->get();
        return view('admin.layouts.accessControl.modules.edit', compact('module','modules','baseLinks'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Module  $module
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request,$id)
    {
        $updateModule = Module::updateModule($request,$id);
        if($request->input('PTGMLNK_ID') == ''){
            $parentModuleID = null;
            $MODLINK_ID = $id;
        }else{
            $parentModuleID = $request->input('PTGMLNK_ID');
            $MODLINK_ID = $parentModuleID;
        }
        $updateData = array(
            'PTGMLNK_ID' => $parentModuleID,
            'MODLINK_ID' => $MODLINK_ID,
        );
        //$this->pr($updateData);
        $data = DB::table('sc_mmnlink')->where('MMNLINK_ID', $id)->update($updateData);
        if($updateModule){
            return redirect('/modules')->with('success','Module has been updated successfully');
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Module  $module
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $delete = Module::deleteModule($id);
        if($delete){
            echo json_encode([
                'type' => 'tr',
                'id' => $id,
                'flag' => true,
                'message' => 'Module Deleted Successfully',
            ]);
        } else{
            echo json_encode([
                'message' => 'Error Found Here!',
            ]);
        }
    }
}
