<?php

namespace App\Http\Controllers;

use App\OrderDeliver;
use App\Order;
use App\ItemStock;
use Illuminate\Http\Request;

class OrderDeliveryController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $ordersDeliver = OrderDeliver::ordersDeliver();
        return view('admin.layouts.orderProcess.delivery.index', compact('ordersDeliver'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\OrderDeliver  $orderDeliver
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $deliverInfo = OrderDeliver::deliverInfo($id);
        $orderDeliverDetails = OrderDeliver::orderDeliverDetails($id);
        $totalPrice = Order::totalPrice($id);
        return view('admin.layouts.orderProcess.delivery.show',compact('orderDeliverDetails','id','deliverInfo','totalPrice'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\OrderDeliver  $orderDeliver
     * @return \Illuminate\Http\Response
     */
    public function edit(OrderDeliver $orderDeliver)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\OrderDeliver  $orderDeliver
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $confirmDelivery = OrderDeliver::confirmDelivery($id);
        // out from stock
        $orders = OrderDeliver::orderDeliverDetails($id);
        foreach ($orders as $order) {
            $stock = array(
                'TRAN_ID' => $order->ORDERMST_ID,
                'TRAN_TYPE' => 'O',
                'PRODUCT_ID' => $order->PRODUCT_ID,
                'PACK_TYPE_ID' => $order->PACK_TYPE_ID,
                'IS_BOX' => $order->IS_BOX_ORDER,
                'QUANTITY' => $order->QUANTITY,
                'UPDATED_BY' => auth()->user()->id,
                'UPDATED_AT' => date('Y-m-d h:i:s'),
            );
            $insert = ItemStock::insert($stock); // Item stock out
        }
        if($confirmDelivery){
            return redirect('/orders-deliver')->with('success','Order has been Finalized successfully');
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\OrderDeliver  $orderDeliver
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
