<?php

namespace App\Http\Controllers;

use App\OrderProcess;
use App\Order;
use App\Organization;
use Illuminate\Http\Request;

class OrderProcessController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $organizations = Organization::organizations();
        $ordersProcess = OrderProcess::ordersProcess();
        return view('admin.layouts.orderProcess.process.index', compact('ordersProcess','organizations'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function orderProcessWithCarry(Request $request)
    {
        $carrierId = $request->input('carrier_id');
        $orders = $request->input('orders_id');
        $orderArrayId = explode(',', $orders);
        $updateOrder = OrderProcess::orderUpdateAsProcess($carrierId, $orderArrayId);
        if($updateOrder){
            $msg = array('success' => 'Order has been processed successfully');
        } else{
            $msg = array('error' => 'Order not processed successfully');
        }
        echo json_encode($msg);
        die();
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\OrderProcess  $ordersReceive
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $processInfo = OrderProcess::processInfo($id);
        $orderProcessDetails = OrderProcess::orderProcessDetails($id);
        $totalPrice = Order::totalPrice($id);
        $organizations = Organization::organizations();
        return view('admin.layouts.orderProcess.process.show',compact('orderProcessDetails','id','processInfo','totalPrice', 'organizations'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\OrderProcess  $ordersReceive
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\OrderProcess  $ordersReceive
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $carrierId = $request->input('carrier_id');
        $updateProcess = OrderProcess::updateProcess($id, $carrierId);
        if($updateProcess){
            return redirect('/orders-process')->with('success','Order has been processed successfully');
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\OrderProcess  $ordersReceive
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
