<?php

namespace App\Http\Controllers;

use App\Organization;
use Illuminate\Http\Request;

class OrganizationController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $header = [
            'createUrl'=>'organizations/create',
            'modalSize'=>'modal-lg',
            'title'=>'Create New Organization',
        ];
        $organizations = Organization::organizations();
        return view('admin.layouts.baseSetup.organizations.index', compact('organizations','header'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('admin.layouts.baseSetup.organizations.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $data = array(
            'ORGANIZATION_NAME'    => $request->input('ORGANIZATION_NAME'),
            'ORGANIZATION_EMAIL'   => $request->input('ORGANIZATION_EMAIL'),
            'ORGANIZATION_ADDRESS' => $request->input('ORGANIZATION_ADDRESS'),
            'ORGANIZATION_CONTACT' => $request->input('ORGANIZATION_CONTACT'),
            'ORGANIZATION_CATEGORY'=> $request->input('ORGANIZATION_CATEGORY'),
            'ACTIVE_FLG'           => $request->input('ACTIVE_FLG'),
            'CREATED_BY'           => auth()->user()->id,
            'CREATED_AT'           => date('Y-m-d h:i:s'),
        );
        $inserted = Organization::insert($data);
        if ($inserted){
            return redirect('organizations')->with('success', 'Organization Added Successfully');
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Organization  $organization
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Organization  $organization
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $organization = Organization::organization($id);
        return view('admin.layouts.baseSetup.organizations.edit', compact('organization'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Organization  $organization
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $data = array(
            'ORGANIZATION_NAME'    => $request->input('ORGANIZATION_NAME'),
            'ORGANIZATION_EMAIL'   => $request->input('ORGANIZATION_EMAIL'),
            'ORGANIZATION_ADDRESS' => $request->input('ORGANIZATION_ADDRESS'),
            'ORGANIZATION_CONTACT' => $request->input('ORGANIZATION_CONTACT'),
            'ORGANIZATION_CATEGORY'=> $request->input('ORGANIZATION_CATEGORY'),
            'ACTIVE_FLG'           => $request->input('ACTIVE_FLG'),
            'UPDATED_BY'           => auth()->user()->id,
            'UPDATED_AT'           => date('Y-m-d h:i:s'),
        );
        $updated = Organization::updateOrganization($data, $id);
        if ($updated){
            return redirect('organizations')->with('success', 'Organization Updated Successfully');
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Organization  $organization
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $delete = Organization::deleteOrganization($id);
        if($delete){
            echo json_encode([
                'type' => 'tr',
                'id' => $id,
                'flag' => true,
                'message' => 'Organization Deleted Successfully',
            ]);
        } else{
            echo json_encode([
                'message' => 'Error Found Here!',
            ]);
        }
    }
}
