<?php

namespace App\Http\Controllers;

use App\PrintProcessedOrder;
use App\Organization;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;


class PrintProcessedOrderController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $processedOrders = PrintProcessedOrder::processedOrders();
        $ordersToDeliver = PrintProcessedOrder::ordersToDeliver();
        $organizations = Organization::organizations();
        //$this->pr($ordersToDeliver);
        return view('admin.layouts.reportsPrint.processedOrders.index', compact( 'processedOrders', 'ordersToDeliverChild', 'organizations', 'ordersToDeliver'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\PrintProcessedOrder  $printProcessedOrder
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $deliverInfo = PrintProcessedOrder::deliverInfo($id);
        $orderDeliverDetails = PrintProcessedOrder::orderDeliverDetails($id);
        $totalPrice = PrintProcessedOrder::totalPrice($id);
        return view('admin.layouts.reportsPrint.processedOrders.show',compact('orderDeliverDetails','id','deliverInfo','totalPrice'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\PrintProcessedOrder  $printProcessedOrder
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\PrintProcessedOrder  $printProcessedOrder
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\PrintProcessedOrder  $printProcessedOrder
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }

    public function searchDeliveryOrders(Request $request)
    {
        $carrierId = $request->input('carrierId');
        $fromDate = date( 'Y-m-d H:i:s', strtotime($request->input('fromDate')) );
        $toDate = date( 'Y-m-d H:i:s', strtotime($request->input('toDate')) );
        $ordersToDeliver = PrintProcessedOrder::ordersToDeliverBySearch($carrierId, $fromDate, $toDate);
        //$this->pr($fromDate);
        return view('admin.layouts.reportsPrint.processedOrders.searchOrders', compact('ordersToDeliver','carrierId', 'fromDate', 'toDate'));
    }
    public function searchDeliveryOrdersPrint(Request $request, $carrierId, $fromDate, $toDate)
    {
        $ordersToDeliver = PrintProcessedOrder::ordersToDeliverBySearch($carrierId, $fromDate, $toDate);
        $html = View('admin.layouts.reportsPrint.processedOrders.searchOrdersPrint',compact('ordersToDeliver'));
        $this->generatePdf($html, 'L', false);

    }
}
