<?php

namespace App\Http\Controllers;
use App\Order;
use App\Organization;
use App\ProductDelivered;
use Illuminate\Http\Request;

class ProductDeliveredController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $ordersDelivered = ProductDelivered::ordersDeliver();
        $organizations = Organization::organizations();
        return view('admin.layouts.orderProcess.productDelivered.index', compact('ordersDelivered', 'organizations'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\ProductDelivered  $productDelivered
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $deliverInfo = ProductDelivered::deliverInfo($id);
        $orderDelivered = ProductDelivered::orderDeliverDetails($id);
        $totalPrice = Order::totalPrice($id);
        return view('admin.layouts.orderProcess.productDelivered.show',compact('orderDelivered','id','deliverInfo','totalPrice'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\ProductDelivered  $productDelivered
     * @return \Illuminate\Http\Response
     */
    public function edit(ProductDelivered $productDelivered)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\ProductDelivered  $productDelivered
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, ProductDelivered $productDelivered)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\ProductDelivered  $productDelivered
     * @return \Illuminate\Http\Response
     */
    public function destroy(ProductDelivered $productDelivered)
    {
        //
    }
}
