<?php

namespace App\Http\Controllers;
use App\LookupGroup;
use App\ProductInfo;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use Intervention\Image\ImageManagerStatic as Image;


class ProductInfoController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $header = [
            'createUrl'=>'product-info/create',
            'modalSize'=>'modal-lg',
            'title'=>'Create New Product',
        ];

        $products = ProductInfo::products();
        return view('admin.layouts.baseSetup.productsInfo.index', compact('header','products'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {

        $medicineCategory = LookupGroup::getMedicineCat($this->medicineCategory);
        $uoms = LookupGroup::getUnityOfMeasurements($this->unityOfMeasurementId);
        return view('admin.layouts.baseSetup.productsInfo.create', compact('medicineCategory','uoms'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        if (!empty($request->file('product_photo'))) {
            $file = $request->file('product_photo');
            // file with extension
            $fileWithExt = $file->getClientOriginalName();
            // file name
            $filename = pathinfo($fileWithExt, PATHINFO_FILENAME);
            // get file extension
            $extension = $file->getClientOriginalExtension();
            // create unique file name
            $productImage = $filename . '_' . time() . '.' . $extension;
            // move to destination
            $destination = base_path() . '/public/uploads/products/';
            $file->move($destination, $productImage);
            //Resize image here
            $productImagePath = $destination.$productImage;
            $img = Image::make($productImagePath)->resize(290, 385);
            $img->save($productImagePath);
        }
        $productId = ProductInfo::addProductInfo($request,$productImage);
        if (!empty($request->file('photo'))) {
            $files = $request->file('photo'); //echo count($files);exit();
            foreach ($files as $file) {
                $fileWithExt = $file->getClientOriginalName();
                $filename = pathinfo($fileWithExt, PATHINFO_FILENAME);
                $extension = $file->getClientOriginalExtension();
                $otherImage = $filename . '_' . time() . '.' . $extension;
                $destination = base_path() . '/public/uploads/products/';
                $file->move($destination, $otherImage);
                //Resize image here
                $otherImagePath = $destination.$otherImage;
                $img = Image::make($otherImagePath)->resize(290, 385);
                $img->save($otherImagePath);

                $insertImage = array(
                    'PRODUCT_ID' => $productId,
                    'IMAGE_LINK' => $otherImage,
                    'ACTIVE_FLG' => 1,
                    'CREATED_BY' => auth()->user()->id,
                    'CREATED_AT' => date('Y-m-d h:i:s')
                );
                ProductInfo::addProductInfoImg($insertImage);
            }
        }
        if ($productId){
            return redirect('/product-info')->with('success', 'Product has been added successfully');
        }else{
            return redirect('/product-info')->with('success', 'There was an error');
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $viewProduct = ProductInfo::viewProductInfo($id);
        $viewProductImg = ProductInfo::viewProductInfoImg($id);//  $this->pr($viewProductImg);
        return view('admin.layouts.baseSetup.productsInfo.show', compact('viewProduct','viewProductImg'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $product = ProductInfo::product($id);
        $medicineCategory = LookupGroup::getMedicineCat($this->medicineCategory);
        $uoms = LookupGroup::getUnityOfMeasurements($this->unityOfMeasurementId);
        $otherImages = ProductInfo::viewProductInfoImg($id);
//        $this->pr($uoms);
        return view('admin.layouts.baseSetup.productsInfo.edit', compact('header','product','medicineCategory','uoms','otherImages'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $productImage = null;
        if (!empty($request->file('product_photo'))) {
            $file = $request->file('product_photo');
            // file with extension
            $fileWithExt = $file->getClientOriginalName();
            // file name
            $filename = pathinfo($fileWithExt, PATHINFO_FILENAME);
            // get file extension
            $extension = $file->getClientOriginalExtension();
            // create unique file name
            $productImage = $filename . '_' . time() . '.' . $extension;
            // move to destination
            $destination = base_path() . '/public/uploads/products/';
            $file->move($destination, $productImage);
            //Resize image here
            $productImagePath = $destination.$productImage;
            $img = Image::make($productImagePath)->resize(290, 385);
            $img->save($productImagePath);
        }
        // update data
        $dataUpdate = ProductInfo::updateProductInfo($request, $id, $productImage);

        // image update
        if (!empty($request->file('photo'))) {
            // delete previous image
            $delProductImage = ProductInfo::delPreviousImage($id);
            // insert new image
            $files = $request->file('photo');
            foreach ($files as $file) {
                // file with extension
                $fileWithExt = $file->getClientOriginalName();
                // file name
                $filename = pathinfo($fileWithExt, PATHINFO_FILENAME);
                // get file extension
                $extension = $file->getClientOriginalExtension();
                // create unique file name
                $otherImage = $filename . '_' . time() . '.' . $extension;
                // move to destination
                $destination = base_path() . '/public/uploads/products/';
                $file->move($destination, $otherImage);
                // resize here
                $otherImagePath = $destination.$otherImage;
                $img = Image::make($otherImagePath)->resize(290, 385);
                $img->save($otherImagePath);
                // upload in table
                $updateImage = array(
                    'PRODUCT_ID' => $id,
                    'IMAGE_LINK' => $otherImage,
                    'ACTIVE_FLG' => 1,
                    'UPDATED_BY' => auth()->user()->id,
                    'UPDATED_AT' => date('Y-m-d h:i:s'),
                );
                $imgInsert = ProductInfo::addProductInfoImg($updateImage);
            }
        }
        // redirect to index
        if($dataUpdate){
            return redirect('/product-info')->with('success','Product has been updated successfully');
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
         $delete = ProductInfo::deleteProductInfo($id);
        if($delete){
            echo json_encode([
                'type' => 'tr',
                'id' => $id,
                'flag' => true,
                'message' => 'Product Deleted Successfully',
            ]);
        } else{
            echo json_encode([
                'message' => 'Error Found Here!',
            ]);
        }
    }
    // ADD product in gallery
    public  static function addProductToWebsite($id){
        //check and update status
        $showStatus = ProductInfo::productViewStatus($id);
        $webViewFg = $showStatus->WEBVIEW_FG;
        $data = array(
            'WEBVIEW_FG' => $webViewFg==1?0:1
        );
        DB::table('sf_product_info')->where('PRODUCT_ID',$id)->update($data);

    }
    public function pr($data){
        echo '<pre>';
        print_r($data);
        exit();
    }
}
