<?php

namespace App\Http\Controllers;

use App\ProductPolicy;
use App\ProductInfo;
use App\LookupGroup;
use Illuminate\Http\Request;

class ProductPolicyController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $header = [
            'createUrl'=>'product-policies/create',
            'modalSize'=>'modal-lg',
            'title'=>'Create New Policy',
        ];
        $policies = ProductPolicy::policies();
        return view('admin.layouts.policies.productsPolicy.index', compact('policies', 'header'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $products = ProductInfo::productsForPolicy();
        $uoms = LookupGroup::getUnityOfMeasurements($this->unityOfMeasurementId);
        return view('admin.layouts.policies.productsPolicy.create', compact('products','uoms'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $data = array(
            'PRODUCT_ID'   => $request->input('PRODUCT_ID'),
            'PACK_TYPE_ID' => $request->input('PACK_TYPE_ID'),
            'DISC_PCT'     => $request->input('DISC_PCT'),
            'FREE_QTY'     => $request->input('FREE_QTY'),
            'POINT'        => $request->input('POINT'),
            'ACTIVE_FLG'   => $request->input('ACTIVE_FLG'),
            'CREATED_BY'   => auth()->user()->id,
            'CREATED_AT'   => date('Y-m-d h:i:s'),
        );
        //$this->pr($data);
        $insert = ProductPolicy::insert($data);
        if($insert){
            return redirect('/product-policies')->with('success','Product Policy has been added successfully');
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Policy  $policy
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Policy  $policy
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $products = ProductInfo::products();
        $uoms = LookupGroup::getUnityOfMeasurements($this->unityOfMeasurementId);
        $policy = ProductPolicy::policy($id);
        return view('admin.layouts.policies.productsPolicy.edit', compact('products','uoms','policy'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Policy  $policy
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $data = array(
            //'PRODUCT_ID'   => $request->input('PRODUCT_ID'),
            'PACK_TYPE_ID' => $request->input('PACK_TYPE_ID'),
            'DISC_PCT'     => $request->input('DISC_PCT'),
            'FREE_QTY'     => $request->input('FREE_QTY'),
            'POINT'        => $request->input('POINT'),
            'ACTIVE_FLG'   => $request->input('ACTIVE_FLG'),
            'UPDATED_BY'   => auth()->user()->id,
            'UPDATED_AT'   => date('Y-m-d h:i:s'),
        );
        //$this->pr($id);
        $updatePolicy = ProductPolicy::updatePolicy($data,$id);
        if($updatePolicy){
            return redirect('product-policies')->with('success','Product Policy has been updated successfully');
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Policy  $policy
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $delete = ProductPolicy::deleteProductPolicy($id);
        if($delete){
            echo json_encode([
                'type' => 'tr',
                'id' => $id,
                'flag' => true,
                'message' => 'Product Policy Deleted Successfully',
            ]);
        } else{
            echo json_encode([
                'message' => 'Error Found Here!',
            ]);
        }
    }
}
