<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Dompdf\Dompdf;
class ReportController extends Controller
{
    public function makePdf($html, $paperFormat = 'landscape', $download = false){
        $dompdf = new Dompdf();
        $dompdf->loadHtml($html);

// (Optional) Setup the paper size and orientation
        $dompdf->setPaper('A4', $paperFormat);

// Render the HTML as PDF
        $dompdf->render();

// Output the generated PDF to Browser
        $dompdf->stream('document.pdf', array('Attachment'=>$download));
    }
}
