<?php

namespace App\Http\Controllers;

use App\TermCondition;
use App\LookupGroup;
use Illuminate\Http\Request;

class TermConditionController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $header = [
            'createUrl'=>'terms-conditions/create',
            'modalSize'=>'modal-lg',
            'title'=>'Create New Terms and Conditions',
        ];
        $termsConditions = TermCondition::termsConditions();
        return view('admin.layouts.baseSetup.termsConditions.index', compact('termsConditions','header'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $paymentTypes = LookupGroup::paymentTypes($this->paymentTypeId);
        return view('admin.layouts.baseSetup.termsConditions.create', compact('paymentTypes'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $data = array(
            'PAYMENT_TYPE_ID'      => $request->input('PAYMENT_TYPE_ID'),
            'TERMS_CONDTIONS_DESC' => $request->input('TERMS_CONDTIONS_DESC'),
            'ACTIVE_FLG'           => $request->input('ACTIVE_FLG'),
            'CREATED_BY'           => auth()->user()->id,
            'CREATED_AT'           => date('Y-m-d h:i:s'),
        );
        $inserted = TermCondition::insert($data);
        if ($inserted){
            return redirect('terms-conditions')->with('success', 'Term and Condition Added Successfully');
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\TermCondition  $termCondition
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\TermCondition  $termCondition
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $paymentTypes = LookupGroup::paymentTypes($this->paymentTypeId);
        $termCondition = TermCondition::termCondition($id);
        return view('admin.layouts.baseSetup.termsConditions.edit',compact('termCondition','paymentTypes'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\TermCondition  $termCondition
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $data = array(
            'PAYMENT_TYPE_ID'      => $request->input('PAYMENT_TYPE_ID'),
            'TERMS_CONDTIONS_DESC' => $request->input('TERMS_CONDTIONS_DESC'),
            'ACTIVE_FLG'           => $request->input('ACTIVE_FLG'),
            'UPDATED_BY'           => auth()->user()->id,
            'UPDATED_AT'           => date('Y-m-d h:i:s'),
        );
        $updated = TermCondition::updateTermCondition($data, $id);
        if ($updated){
            return redirect('terms-conditions')->with('success', 'Term and Condition Updated Successfully');
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\TermCondition  $termCondition
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $delete = TermCondition::deleteTermCondition($id);
        if($delete){
            echo json_encode([
                'type' => 'tr',
                'id' => $id,
                'flag' => true,
                'message' => 'Term and Condition Deleted Successfully',
            ]);
        } else{
            echo json_encode([
                'message' => 'Error Found Here!',
            ]);
        }
    }
}
