<?php

namespace App\Http\Controllers;

use App\LookupGroup;
use App\User;
use App\UserGroup;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;

class UserController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $header = [
            'createUrl'=>'users/create',
            'modalSize'=>'modal-lg',
            'title'=>'Create New User',
        ];
        $users = User::users();
        //$this->pr($users);
        return view('admin.layouts.accessControl.users.index',compact('users','header'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $userGroups  = UserGroup::getUserGroups();
        $departments = LookupGroup::departments($this->departmentId);
        $designations = LookupGroup::designations($this->designationId);
        return view('admin.layouts.accessControl.users.create', compact('userGroups', 'departments','designations'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //return redirect('users');
        if (!empty($request->file('photo'))) {
            $file = $request->file('photo');
                // file with extension
                $fileWithExt = $file->getClientOriginalName();
                // file name
                $filename = pathinfo($fileWithExt, PATHINFO_FILENAME);
                // get file extension
                $extension = $file->getClientOriginalExtension();
                // create unique file name
                $fileToUpload = $filename . '_' . time() . '.' . $extension;
                // move to destination
                $destination = base_path() . '/public/uploads/users';
                $file->move($destination, $fileToUpload);
        }else{
            $fileToUpload = 'defaultUserPic.png';
        }
        $data = array(
            'username'   => $request->input('username'),
            'email'      => $request->input('email'),
            'DESGTON_ID' => $request->input('DESGTON_ID'),
            'DEPRTMN_ID' => $request->input('DEPRTMN_ID'),
            'MNLAGRP_ID' => $request->input('MNLAGRP_ID'),
            'password'   => Hash::make($request->input('password')),
            'EFECTIV_DT' => $request->input('EFECTIV_DT'),
            'UEXPIRE_DT' => $request->input('UEXPIRE_DT'),
            'USER_PHOTO' => $fileToUpload,
            'ASTATUS_FG' => $request->input('ASTATUS_FG'),
            'CREATED_BY' => auth()->user()->id,
            'CREATED_AT' => date('Y-m-d h:i:s'),
        );
        $addUser = User::addUser($data);
        if($addUser){
            return redirect('/users')->with('success','User has been created successfully');
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $userGroups = UserGroup::getUserGroups();
        $editUser   = User::editUser($id);
        $departments = LookupGroup::departments($this->departmentId);
        $designations = LookupGroup::designations($this->designationId);
        //$this->pr($departments);
        return view('admin.layouts.accessControl.users.edit', compact('userGroups','editUser','departments','designations'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        if (!empty($request->file('photo'))) {
            $file = $request->file('photo');
            // file with extension
            $fileWithExt = $file->getClientOriginalName();
            // file name
            $filename = pathinfo($fileWithExt, PATHINFO_FILENAME);
            // get file extension
            $extension = $file->getClientOriginalExtension();
            // create unique file name
            $fileToUpload = $filename . '_' . time() . '.' . $extension;
            // move to destination
            $destination = base_path() . '/public/uploads/users';
            $file->move($destination, $fileToUpload);
        }else{
            $fileToUpload = 'defaultUserPic.png';
        }
        $updateUser = User::updateUser($request,$id,$fileToUpload);
        if($updateUser){
            return redirect('/users')->with('success','User has been updated successfully');
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $delete = User::delUser($id);
        if($delete){
            echo json_encode([
                'type' => 'tr',
                'id' => $id,
                'flag' => true,
                'message' => 'User Deleted Successfully',
            ]);
        } else{
            echo json_encode([
                'message' => 'Error Found Here!',
            ]);
        }
    }
}
