<?php

namespace App\Http\Controllers;

use App\UserGroup;
use Illuminate\Http\Request;


class UserGroupController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $header = [
            'createUrl'=>'user-groups/create',
            'modalSize'=>'modal-md',
            'title'=>'Create New User Group',
        ];
        $userGroup = UserGroup::getUserGroups();
        return view('admin.layouts.accessControl.userGroups.index',compact('userGroup','header'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {

        $userGroup = UserGroup::getUserGroups();
        return view('admin.layouts.accessControl.userGroups.create', compact('userGroup'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $data = array(
            'AGRP_ENAME' => $request->input('AGRP_ENAME'),
            'AGRP_N_KEY' => $request->input('AGRP_N_KEY'),
            'PTG_GRP_ID' => $request->input('PTG_GRP_ID'),
            'USERDSL_NO' => $request->input('USERDSL_NO'),
            'ASTATUS_FG' => $request->input('ASTATUS_FG'),
            'CREATED_BY' => auth()->user()->id,
            'CREATED_AT' => date('Y-m-d h:i:s'),
        );
        $addUserGroup = UserGroup::addUserGroup($data);
        if($addUserGroup){
            return redirect('/user-groups')->with('success','User Group has been added successfully');
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\UserGroup  $userGroup
     * @return \Illuminate\Http\Response
     */
    public function show(UserGroup $userGroup)
    {

    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\UserGroup  $userGroup
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $userGroup = UserGroup::getUserGroups();
        $editData  = UserGroup::editUserGroup($id);
        return view('admin.layouts.accessControl.userGroups.edit', compact('userGroup','editData'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\UserGroup  $userGroup
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $updateUserGroup = UserGroup::updateUserGroup($request,$id);
        if($updateUserGroup){
            return redirect('/user-groups')->with('success','User Group has been updated successfully');
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\UserGroup  $userGroup
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $delete = UserGroup::deleteUserGroup($id);
        if($delete){
            echo json_encode([
                'flag' => true,
                'message' => 'User Group Deleted Successfully',
            ]);
        } else{
            echo json_encode([
                'message' => 'Error Found Here!',
            ]);
        }
    }
}
