<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;

class ItemStock extends Model
{
    public static function stocks(){
        return DB::table('sf_itemstock')
            ->select('sf_itemstock.*',  'sf_product_info.PROD_NAME' ,'sc_lkpdata.LDATA_NAME as packetType',
                DB::raw("(SELECT sum(si.QUANTITY) FROM sf_itemstock as si WHERE sf_itemstock.PRODUCT_ID=si.PRODUCT_ID and sf_itemstock.PACK_TYPE_ID=si.PACK_TYPE_ID and sf_itemstock.IS_BOX = si.IS_BOX and si.TRAN_TYPE = 'I') as stock_in"),
                DB::raw("(SELECT sum(si.QUANTITY) FROM sf_itemstock as si WHERE sf_itemstock.PRODUCT_ID=si.PRODUCT_ID and sf_itemstock.PACK_TYPE_ID=si.PACK_TYPE_ID and sf_itemstock.IS_BOX = si.IS_BOX and si.TRAN_TYPE = 'O') as stock_out")
            )
            ->leftJoin('sf_product_info', 'sf_itemstock.PRODUCT_ID','=','sf_product_info.PRODUCT_ID')
            ->leftJoin('sc_lkpdata', 'sf_itemstock.PACK_TYPE_ID','=','sc_lkpdata.LKP_DATAID')
            ->groupBy('sf_itemstock.PRODUCT_ID','sf_itemstock.PACK_TYPE_ID','sf_itemstock.IS_BOX')
            ->get();
    }
    public static function insert($data){
        return DB::table('sf_itemstock')->insert($data);
    }

    public static function currentStock($productId, $packTypeId, $isBox){
        $stockInfo = DB::table('sf_itemstock')
            ->select(
                DB::raw("(SELECT sum(si.QUANTITY) FROM sf_itemstock as si WHERE sf_itemstock.PRODUCT_ID=si.PRODUCT_ID and sf_itemstock.PACK_TYPE_ID=si.PACK_TYPE_ID and sf_itemstock.IS_BOX = si.IS_BOX and si.TRAN_TYPE = 'I') as stock_in"),
                DB::raw("(SELECT sum(si.QUANTITY) FROM sf_itemstock as si WHERE sf_itemstock.PRODUCT_ID=si.PRODUCT_ID and sf_itemstock.PACK_TYPE_ID=si.PACK_TYPE_ID and sf_itemstock.IS_BOX = si.IS_BOX and si.TRAN_TYPE = 'O') as stock_out")
            )
            ->where('sf_itemstock.PRODUCT_ID', '=', $productId)
            ->where('sf_itemstock.PACK_TYPE_ID', '=', $packTypeId)
            ->where('sf_itemstock.IS_BOX', '=', $isBox)
            ->first();
        $currentStock = $stockInfo->stock_in-$stockInfo->stock_out;
        return $currentStock;
    }


}
