<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;

class LookupData extends Model
{
    // insert lookup data
    public static function insertLookupData($data){
        return DB::table('sc_lkpdata')->insert($data);
    }
    // return data to update
    public static function getLookupData($id){
        return DB::table('sc_lkpdata')->select('*')->where('LKP_DATAID',$id)->first();
    }
    // update lookup data
    public static function updateLookupData($request,$id){
        return DB::table('sc_lkpdata')->where('LKP_DATAID', '=' , $id)->update([
            'LDATA_NAME' => $request->input('LDATA_NAME'),
            'USERDSL_NO' => $request->input('USERDSL_NO'),
            'ASTATUS_FG' => $request->input('ASTATUS_FG'),
            'UPDATED_BY' => auth()->user()->id,
            'UPDATED_AT' => date('Y-m-d h:i:s'),
        ]);
    }
    // delete lookup data
    public static function deleteLookupData($id){
        return DB::table('sc_lkpdata')->where('LKP_DATAID', $id)->delete();
    }

}
