<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;

class LookupGroup extends Model
{
    // insert base group
    public static function insertBaseGroup($data){
        return DB::table('sc_lkp_grp')->insert($data);
    }
    // edit base group
    public static function getLookupGroup($id){
        return DB::table('sc_lkp_grp')->select('*')->where('LKP_GRP_ID',$id)->first();
    }
    // update lookup group
    public static function updateLookupGroup($request,$id){
        return DB::table('sc_lkp_grp')->where('LKP_GRP_ID', '=' , $id)->update([
            'LKPGRPNAME' => $request->input('LKPGRPNAME'),
            'UDLKPGRPNO' => $request->input('UDLKPGRPNO'),
            'ASTATUS_FG' => $request->input('ASTATUS_FG'),
            'UPDATED_BY' => auth()->user()->id,
            'UPDATED_AT' => date('Y-m-d h:i:s'),
        ]);
    }
    // delete lookup group
    public static function deleteLookupGroup($id){
        $delLookupData = DB::table('sc_lkpdata')->where('LKP_GRP_ID', $id)->delete();
        if($delLookupData){
            return DB::table('sc_lkp_grp')->where('LKP_GRP_ID', $id)->delete();
        }
    }

    //===========================================lookup drop down list========================
    // Product Info setup

    public static function paymentTypes($id){
        return DB::table('sc_lkpdata')
            ->select('LKP_DATAID as ID', 'LDATA_NAME as NAME')
            ->where('LKP_GRP_ID',$id)
            ->where('ASTATUS_FG', '=', 1)
            ->get();
    }

    public static function getMedicineCat($id){
        return DB::table('sc_lkpdata')
            ->where('LKP_GRP_ID',$id)
            ->where('ASTATUS_FG', '=', 1)
            ->get();
    }
    public static function getUnityOfMeasurements($id){
        return DB::table('sc_lkpdata')
            ->where('LKP_GRP_ID',$id)
            ->where('ASTATUS_FG', '=', 1)
            ->get();
    }
    // celebrity registration
    public static function countryList($id){
        return DB::table('sc_lkpdata')
            ->where('LKP_GRP_ID',$id)
            ->where('ASTATUS_FG', '=', 1)
            ->get();
    }
    public static function provinceList($id){
        return DB::table('sc_lkpdata')
            ->where('LKP_GRP_ID',$id)
            ->where('ASTATUS_FG', '=', 1)
            ->get();
    }
    public static function districtList($id){
        return DB::table('sc_lkpdata')
            ->where('LKP_GRP_ID',$id)
            ->where('ASTATUS_FG', '=', 1)
            ->get();
    }
    public static function regionList($id){
        return DB::table('sc_lkpdata')
            ->where('LKP_GRP_ID',$id)
            ->where('ASTATUS_FG', '=', 1)
            ->get();
    }
    // bank list
    public static function bankList($id){
        return DB::table('sc_lkpdata')
            ->where('LKP_GRP_ID',$id)
            ->where('ASTATUS_FG', '=', 1)
            ->get();
    }
    // departments
    public static function departments($id){
        return DB::table('sc_lkpdata')
            ->where('LKP_GRP_ID', $id)
            ->where('ASTATUS_FG', '=', 1)
            ->get();
    }
    // designations
    public static function designations($id){
        return DB::table('sc_lkpdata')
            ->where('LKP_GRP_ID', $id)
            ->where('ASTATUS_FG', '=', 1)
            ->get();
    }

} // class end
