<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;

class Module extends Model
{
    protected $table = 'sc_mmnlink';

    // add module
    public static function addNewModule($request){
        $moduleId = DB::table('sc_mmnlink')->insertGetId([
            'MLINK_NAME' => $request->input('MLINK_NAME'),
            'MNLNK_TYPE' => $request->input('MNLNK_TYPE'),
            //'PTGMLNK_ID' => $request->input('PTGMLNK_ID'),
            'BASELNK_ID' => $request->input('BASELNK_ID'),
            'MENUB_ICON' => $request->input('MENUB_ICON'),
            'ASTATUS_FG' => $request->input('ASTATUS_FG'),
            'CREATED_BY' => auth()->user()->id,
            'CREATED_AT' => date('Y-m-d h:i:s'),
        ]);
        return $moduleId;
    }

    public static function modules(){
        return DB::table('sc_mmnlink')
            ->where('PTGMLNK_ID', null)
            ->where('MNLNK_TYPE', 'M')
            ->where('ASTATUS_FG','1')
            ->get();
    }

    public static function moduleLink(){
        return DB::table('sc_mmnlink')
            ->whereNotNull('PTGMLNK_ID')
            ->where('MNLNK_TYPE', 'L')
            ->get();
    }

    // Edit module
    public static function module($id){
        return DB::table('sc_mmnlink')->where('MMNLINK_ID', $id)->first();
    }
    // add module
    public static function updateModule($request,$id){
        return DB::table('sc_mmnlink')->where('MMNLINK_ID', '=' , $id)->update([
            'MLINK_NAME' => $request->input('MLINK_NAME'),
            'MNLNK_TYPE' => $request->input('MNLNK_TYPE'),
            //'PTGMLNK_ID' => $request->input('PTGMLNK_ID'),
            'BASELNK_ID' => $request->input('BASELNK_ID'),
            'MENUB_ICON' => $request->input('MENUB_ICON'),
            'ASTATUS_FG' => $request->input('ASTATUS_FG'),
            'UPDATED_BY' => auth()->user()->id,
            'UPDATED_AT' => date('Y-m-d h:i:s'),
        ]);
    }

    public static function deleteModule($id){
        return DB::table('sc_mmnlink')->where('MMNLINK_ID', $id)->delete();
    }



}
