<?php

namespace App;
use Illuminate\Support\Facades\DB;

use Illuminate\Database\Eloquent\Model;

class ModuleAssign extends Model
{
    protected $table = 'sc_grplink';

    protected $guarded = [];

    public static function moduleLinks($userGroupId){
        return DB::table('sc_mmnlink as sml')
            ->select('sml.MMNLINK_ID','sml.MLINK_NAME','sml.BASELNK_ID','sml.MNLNK_TYPE','sml.PTGMLNK_ID','sml.MODLINK_ID','sbl.BLNK_ENAME','sgl.GRPLINK_ID', 'sgl.MNLAGRP_ID','sgl.CRUDLAC_FG','sgl.CRUDLAR_FG','sgl.CRUDLAU_FG','sgl.CRUDLAD_FG','sgl.ASTATUS_FG')
            ->leftJoin('sc_baselnk as sbl', 'sml.BASELNK_ID','=', 'sbl.BASELNK_ID')
            ->leftJoin('sc_grplink as sgl', function($join) use ($userGroupId){ $join->on('sml.MMNLINK_ID', '=', 'sgl.MMNLINK_ID')->where('sgl.MNLAGRP_ID', '=', $userGroupId); })
            ->where('sml.MNLNK_TYPE','L')
            ->where('sml.ASTATUS_FG','1')
            ->groupBy('sml.BASELNK_ID')
            ->orderBy('sbl.USERDSL_NO', 'ASC')
            ->get();
    }
}
