<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;


class Order extends Model
{
    // orders
    public static function orders(){
        return DB::table('sf_ordermst')
            ->leftJoin('sf_customers', 'sf_ordermst.CUSTOMER_ID', '=', 'sf_customers.CUSTOMER_ID')
            ->orderBy('ORDERMST_ID', 'DESC')
            ->get();
    }

//    public static function ordersActive(){
//        return DB::table('sf_ordermst')
//            ->select('sf_customers.USERNAME', 'sf_ordermst.*', 'sf_orderchd.PRICE','sc_lkpdata.LDATA_NAME as paymentType')
//            ->leftJoin('sf_customers', 'sf_ordermst.CUSTOMER_ID', '=', 'sf_customers.CUSTOMER_ID')
//            ->leftJoin('sf_orderchd', 'sf_ordermst.ORDERMST_ID', '=', 'sf_orderchd.ORDERMST_ID')
//            ->leftJoin('sc_lkpdata', 'sf_ordermst.PAYMENT_TYPE_ID', '=', 'sc_lkpdata.LKP_DATAID')
//            ->where('sf_ordermst.ORDER_FLG','=',0)
//            ->where('sf_ordermst.PAYMENT_FLG','=',1)
//            ->groupBy('sf_ordermst.ORDERMST_ID')
//            ->orderBy('sf_ordermst.ORDERMST_ID', 'DESC')
//            ->get();
//    }
    public static function ordersActive(){
        return DB::table('sf_ordermst')
            ->select('sf_customers.USERNAME', 'sf_ordermst.*', DB::raw('SUM(sf_orderchd.PRICE) as totalAmount'),'sc_lkpdata.LDATA_NAME as paymentType')
            ->leftJoin('sf_customers', 'sf_ordermst.CUSTOMER_ID', '=', 'sf_customers.CUSTOMER_ID')
            ->leftJoin('sf_orderchd', 'sf_ordermst.ORDERMST_ID', '=', 'sf_orderchd.ORDERMST_ID')
            ->leftJoin('sc_lkpdata', 'sf_ordermst.PAYMENT_TYPE_ID', '=', 'sc_lkpdata.LKP_DATAID')
            ->where('sf_ordermst.ORDER_FLG','=',0)
            ->where('sf_ordermst.PAYMENT_FLG','=',1)
            ->where('sf_ordermst.DELIVERY_FLG','=',0)
            ->groupBy('sf_ordermst.ORDERMST_ID')
            ->orderBy('sf_ordermst.ORDERMST_ID', 'DESC')
            ->get();
    }
    public static function order($id){
        return DB::table('sf_ordermst')
            ->leftJoin('sc_lkpdata', 'sf_ordermst.PAYMENT_TYPE_ID', '=', 'sc_lkpdata.LKP_DATAID')
            ->where('ORDERMST_ID',$id)
            ->first();
    }

    public static function orderByCustomer($customerId){
        $data = DB::select("select om.*, sum(oc.PRICE) as TOTAL_PRICE from sf_ordermst om 
                left join sf_orderchd oc on om.ORDERMST_ID = oc.ORDERMST_ID
                where om.CUSTOMER_ID=$customerId and om.PAYMENT_FLG=0  group by om.ORDERMST_ID order by om.ORDERMST_ID desc limit 1");
        if($data){
            return $data[0];
        }
        return false;
    }

    public static function insertMst($data){
        return DB::table('sf_ordermst')->insertGetId($data);
    }

    public static function insertChd($data){
        return DB::table('sf_orderchd')->insert($data);
    }

    public static function totalPrice($id){
        return DB::table('sf_orderchd')
            ->where('ORDERMST_ID',$id)
            ->sum('sf_orderchd.PRICE');
//            ->sum(DB::raw('sf_orderchd.PRICE+sf_orderchd.VAT_AMT-sf_orderchd.DISC_AMT'));
    }
    public static function orderDetails($id){
        return DB::table('sf_orderchd as so')
            ->select('so.*','sp.*', 'sc_lkpdata.LDATA_NAME as packType')
            ->leftjoin('sf_product_info as sp','so.PRODUCT_ID','=','sp.PRODUCT_ID')
            ->leftJoin('sc_lkpdata', 'so.PACK_TYPE_ID','=','sc_lkpdata.LKP_DATAID')
            ->where('so.ORDERMST_ID',$id)
            ->get();
    }
    public static function updateMst($id){
        return DB::table('sf_ordermst')->where('ORDERMST_ID', '=' , $id)->update([
            'ORDER_FLG' => 1,
            'UPDATED_BY' => auth()->user()->id,
            'UPDATED_AT' => date('Y-m-d h:i:s'),
        ]);
    }

    //======================= customer ===================
    public static function customerOrders($id){
        return DB::table('sf_ordermst as som')
            ->select('som.*', 'soc.QUANTITY', DB::raw('SUM(soc.PRICE) as totalAmount'), 'spi.*')
            ->leftjoin('sf_orderchd as soc','som.ORDERMST_ID','=','soc.ORDERMST_ID')
            ->leftjoin('sf_product_info as spi','soc.PRODUCT_ID','=','spi.PRODUCT_ID')
            ->where('som.CUSTOMER_ID',$id)
            ->where('som.PAYMENT_FLG','=', 1)
            ->groupBy('som.ORDERMST_ID')
            ->orderBy('som.ORDERMST_ID', 'DESC')
            ->get();
    }
    public static function customerOrdersDetails($id){
        return DB::table('sf_orderchd as soc')
            ->select('soc.QUANTITY','soc.PRICE','soc.PACK_TYPE_ID','soc.IS_BOX_ORDER', 'spi.PROD_NAME', 'spi.PROD_CODE', 'spi.PRODUCT_IMG','spi.UNIT_PRICE', 'spi.BOX_PRICE','sp.DISC_PCT')
            ->leftjoin('sf_product_info as spi','soc.PRODUCT_ID','=','spi.PRODUCT_ID')
            ->leftjoin('sf_policy as sp','soc.PRODUCT_ID','=','sp.PRODUCT_ID')
            ->leftJoin('sc_lkpdata', 'soc.PACK_TYPE_ID', '=', 'sc_lkpdata.LKP_DATAID')
            ->where('soc.ORDERMST_ID',$id)
            ->orderBy('soc.ORDERCHD_ID', 'DESC')
            ->get();
    }


    public static function updatePaymentStatus($orderId, $paymentType){
        return DB::table('sf_ordermst')->where('ORDERMST_ID', '=' , $orderId)->update([
            'PAYMENT_FLG' => 1,
            'PAYMENT_TYPE_ID' => $paymentType,
            'UPDATED_AT' => date('Y-m-d h:i:s'),
        ]);
    }


}
