<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;

class OrderProcess extends Model
{
    public static function ordersProcess(){
        return DB::table('sf_ordermst')
            ->select('sf_customers.USERNAME', 'sf_ordermst.*', DB::raw('SUM(sf_orderchd.PRICE) as totalAmount'),'sc_lkpdata.LDATA_NAME as paymentType')
            ->leftJoin('sf_customers', 'sf_ordermst.CUSTOMER_ID', '=', 'sf_customers.CUSTOMER_ID')
            ->leftJoin('sc_lkpdata', 'sf_ordermst.PAYMENT_TYPE_ID', '=', 'sc_lkpdata.LKP_DATAID')
            ->leftJoin('sf_orderchd', 'sf_ordermst.ORDERMST_ID', '=', 'sf_orderchd.ORDERMST_ID')
            ->where('ORDER_FLG','=',1)
            ->where('sf_ordermst.DELIVERY_FLG','=',0)
            ->groupBy('sf_ordermst.ORDERMST_ID')
            ->orderBy('sf_ordermst.ORDERMST_ID', 'DESC')
            ->get();
    }

    public static function processInfo($id){
        return DB::table('sf_ordermst')
            ->leftJoin('sc_lkpdata', 'sf_ordermst.PAYMENT_TYPE_ID', '=', 'sc_lkpdata.LKP_DATAID')
            ->where('ORDERMST_ID',$id)
            ->first();
    }

    public static function orderProcessDetails($id){
        return DB::table('sf_orderchd as so')
            ->select('so.*','sp.*', 'sc_lkpdata.LDATA_NAME as packType')
            ->leftjoin('sf_product_info as sp','so.PRODUCT_ID','=','sp.PRODUCT_ID')
            ->leftJoin('sc_lkpdata', 'so.PACK_TYPE_ID','=','sc_lkpdata.LKP_DATAID')
            ->where('so.ORDERMST_ID',$id)
            ->get();
    }

    public static function updateProcess($id, $carrierId){
        return DB::table('sf_ordermst')->where('ORDERMST_ID', '=' , $id)->update([
            'DELIVERY_FLG' => 1,
            'CARRIER_ID' => $carrierId,
            'UPDATED_BY' => auth()->user()->id,
            'UPDATED_AT' => date('Y-m-d h:i:s'),
        ]);
    }

    public static function orderUpdateAsProcess($carierId, $orderArrayId){
        return DB::table('sf_ordermst')->whereIn('ORDERMST_ID', $orderArrayId)->update([
            'DELIVERY_FLG' => 1,
            'CARRIER_ID' => $carierId,
            'UPDATED_BY' => auth()->user()->id,
            'UPDATED_AT' => date('Y-m-d h:i:s'),
        ]);
    }
}
