<?php

namespace App;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;
use Illuminate\Database\Eloquent\Model;

class Permission extends Model
{
//    For Sidebar
    public static function permissionSidebar($linkId){
        $userGroupId = Auth::user()->MNLAGRP_ID;
        $permissions = DB::table('sc_mmnlink as sml')
            ->select('sml.BASELNK_ID', 'ss.username', 'ss.MNLAGRP_ID', 'sgl.MMNLINK_ID', 'sgl.ASTATUS_FG', 'sml.MLINK_NAME', 'sml.PTGMLNK_ID', 'sbl.ROUTE_URLS')
            ->leftjoin('sc_baselnk as sbl','sml.BASELNK_ID','=','sbl.BASELNK_ID')
            ->leftjoin('sc_grplink as sgl','sml.MMNLINK_ID','=','sgl.MMNLINK_ID')
            ->leftjoin('sc_sausers as ss','sgl.MNLAGRP_ID','=','ss.MNLAGRP_ID')
            ->where('ss.MNLAGRP_ID', $userGroupId)
            ->where('sml.PTGMLNK_ID', $linkId)
            ->where('sml.MNLNK_TYPE','L')
            ->where('sgl.ASTATUS_FG','1')
            ->orderBy('sbl.USERDSL_NO','ASC')
            ->get();

        return $permissions;
    }

    //    Use in Route (web)
    public static function permissions(){
        $permissions = DB::table('sc_mmnlink as sml')
            ->select('sml.BASELNK_ID', 'ss.username', 'ss.MNLAGRP_ID', 'sgl.MMNLINK_ID', 'sgl.ASTATUS_FG', 'sml.MLINK_NAME', 'sml.PTGMLNK_ID', 'sbl.ROUTE_URLS')
            ->leftjoin('sc_baselnk as sbl','sml.BASELNK_ID','=','sbl.BASELNK_ID')
            ->leftjoin('sc_grplink as sgl','sml.MMNLINK_ID','=','sgl.MMNLINK_ID')
            ->leftjoin('sc_sausers as ss','sgl.MNLAGRP_ID','=','ss.MNLAGRP_ID')
            ->whereNotNull('sml.PTGMLNK_ID')
            ->where('sml.MNLNK_TYPE','L')
            ->orderBy('sbl.USERDSL_NO','ASC')
            ->get();

        return $permissions;
    }
}
