<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;

class PrintProcessedOrder extends Model
{
    public static function processedOrders(){
        return DB::table('sf_ordermst')
            ->select('sf_customers.USERNAME', 'sf_ordermst.*', DB::raw('SUM(sf_orderchd.PRICE) as totalAmount'),'sc_lkpdata.LDATA_NAME as paymentType')
            ->leftJoin('sf_customers', 'sf_ordermst.CUSTOMER_ID', '=', 'sf_customers.CUSTOMER_ID')
            ->leftJoin('sc_lkpdata', 'sf_ordermst.PAYMENT_TYPE_ID', '=', 'sc_lkpdata.LKP_DATAID')
            ->leftJoin('sf_orderchd', 'sf_ordermst.ORDERMST_ID', '=', 'sf_orderchd.ORDERMST_ID')
            ->where('sf_ordermst.ORDER_FLG','=',1)
            ->where('sf_ordermst.DELIVERY_FLG','=',1)
            ->where('sf_ordermst.FINALIZE_FLG','=',0)
            ->groupBy('sf_ordermst.ORDERMST_ID')
            ->orderBy('sf_ordermst.ORDERMST_ID', 'DESC')
            ->get();
    }
    public static function deliverInfo($id){
        return DB::table('sf_ordermst')
            ->leftJoin('sc_lkpdata', 'sf_ordermst.PAYMENT_TYPE_ID', '=', 'sc_lkpdata.LKP_DATAID')
            ->where('ORDERMST_ID',$id)
            ->first();
    }
    public static function orderDeliverDetails($id){
        return DB::table('sf_orderchd as so')
            ->select('so.*','sp.*')
            ->leftjoin('sf_product_info as sp','so.PRODUCT_ID','=','sp.PRODUCT_ID')
            ->where('ORDERMST_ID',$id)
            ->get();
    }
    public static function totalPrice($id){
        return DB::table('sf_orderchd')
            ->where('ORDERMST_ID',$id)
            ->sum('sf_orderchd.PRICE');
    }

    public static function ordersToDeliver(){
        return DB::table('sf_ordermst')
            ->select('sf_ordermst.*','sf_customers.USERNAME','lkd.LDATA_NAME as paymentType')
            ->leftJoin('sc_lkpdata as lkd', 'sf_ordermst.PAYMENT_TYPE_ID', '=', 'lkd.LKP_DATAID')
            ->leftJoin('sf_customers', 'sf_ordermst.CUSTOMER_ID', '=', 'sf_customers.CUSTOMER_ID')
            ->where('sf_ordermst.DELIVERY_FLG','=',1)
            ->where('sf_ordermst.FINALIZE_FLG','=',0)
            ->get();
    }
    public static function ordersToDeliverBySearch($carrierId, $fromDate, $toDate){
        return DB::table('sf_ordermst')
            ->select('sf_ordermst.*','sf_customers.USERNAME','lkd.LDATA_NAME as paymentType')
            ->leftJoin('sc_lkpdata as lkd', 'sf_ordermst.PAYMENT_TYPE_ID', '=', 'lkd.LKP_DATAID')
            ->leftJoin('sf_customers', 'sf_ordermst.CUSTOMER_ID', '=', 'sf_customers.CUSTOMER_ID')
            ->where('sf_ordermst.DELIVERY_FLG','=',1)
            ->where('sf_ordermst.FINALIZE_FLG','=',0)
            ->where('sf_ordermst.CARRIER_ID','=',$carrierId)
            ->where('sf_ordermst.DELIVERY_DATE', '>=', $fromDate)
            ->where('sf_ordermst.DELIVERY_DATE', '<=', $toDate)
            ->get();
    }
}
