<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;

class ProductDelivered extends Model
{
    public static function ordersDeliver(){
        return DB::table('sf_ordermst')
            ->select('sf_customers.USERNAME', 'sf_ordermst.*', DB::raw('SUM(sf_orderchd.PRICE) as totalAmount'),'sc_lkpdata.LDATA_NAME as paymentType')
            ->leftJoin('sf_customers', 'sf_ordermst.CUSTOMER_ID', '=', 'sf_customers.CUSTOMER_ID')
            ->leftJoin('sc_lkpdata', 'sf_ordermst.PAYMENT_TYPE_ID', '=', 'sc_lkpdata.LKP_DATAID')
            ->leftJoin('sf_orderchd', 'sf_ordermst.ORDERMST_ID', '=', 'sf_orderchd.ORDERMST_ID')
            ->where('sf_ordermst.FINALIZE_FLG','=',1)
            ->groupBy('sf_ordermst.ORDERMST_ID')
            ->orderBy('sf_ordermst.ORDERMST_ID', 'DESC')
            ->get();
    }
    public static function deliverInfo($id){
        return DB::table('sf_ordermst')
            ->leftJoin('sc_lkpdata', 'sf_ordermst.PAYMENT_TYPE_ID', '=', 'sc_lkpdata.LKP_DATAID')
            ->where('ORDERMST_ID',$id)
            ->first();
    }

    public static function orderDeliverDetails($id){
        return DB::table('sf_orderchd as so')
            ->select('so.*','sp.*')
            ->leftjoin('sf_product_info as sp','so.PRODUCT_ID','=','sp.PRODUCT_ID')
            ->where('ORDERMST_ID',$id)
            ->get();
    }
    public static function confirmDelivery($id){
        return DB::table('sf_ordermst')->where('ORDERMST_ID', '=' , $id)->update([
            'FINALIZE_FLG' => 1,
            'UPDATED_BY' => auth()->user()->id,
            'UPDATED_AT' => date('Y-m-d h:i:s'),
        ]);
    }
}
