<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;

class ProductInfo extends Model
{
    // all product list
    public static function products(){
        $data = DB::table('sf_product_info')
            ->select('sf_product_info.*','sc_lkpdata.LDATA_NAME')
            ->leftJoin('sc_lkpdata', 'sf_product_info.PACK_TYPE_ID','=','sc_lkpdata.LKP_DATAID')
            ->orderBy('PRODUCT_ID','DESC')
            ->get();

        return $data;
    }

    public static function productsForPolicy(){
        $products = DB::table('sf_policy')->select('PRODUCT_ID')->get();
        $productArray = array();
        foreach ($products as $product){
            $productArray[] = $product->PRODUCT_ID;
        }
        $data = DB::table('sf_product_info')
            ->select('sf_product_info.*','sc_lkpdata.LDATA_NAME')
            ->leftJoin('sc_lkpdata', 'sf_product_info.PACK_TYPE_ID','=','sc_lkpdata.LKP_DATAID')
            ->whereNotIn('sf_product_info.PRODUCT_ID', $productArray)
            ->orderBy('PROD_NAME','asc')
            ->get();

        return $data;
    }

    // add product info
    public static function addProductInfo($request,$productImage){
        $productId = DB::table('sf_product_info')->insertGetId([
            'PROD_NAME'    => $request->input('PROD_NAME'),
            'PROD_CODE'    => $request->input('PROD_CODE'),
            'CATEGORY_ID'  => $request->input('CATEGORY_ID'),
            'PACK_TYPE_ID' => $request->input('PACK_TYPE_ID'),
            'UNIT_PRICE'   => $request->input('UNIT_PRICE'),
//            'STRIPS_PRICE' => $request->input('STRIPS_PRICE'),
//            'BOTTLE_PRICE' => $request->input('BOTTLE_PRICE'),
            'BOX_PRICE'    => $request->input('BOX_PRICE'),
            'IS_SELL_BOX'  => $request->input('IS_SELL_BOX'),
            'INGREDIENTS'  => $request->input('INGREDIENTS'),
            'FUNCTIONALITY'=> $request->input('FUNCTIONALITY'),
            'MANUFACTURE_INFO'=> $request->input('MANUFACTURE_INFO'),
            'PRODUCT_IMG'   => $productImage,
            'ACTIVE_FLG'   => $request->input('ACTIVE_FLG'),
            'CREATED_BY'   => auth()->user()->id,
            'CREATED_AT'   => date('Y-m-d h:i:s'),
        ]);

        return $productId;
    }
    // add product info img
    public static function addProductInfoImg($data){
        return DB::table('sf_product_img')->insert($data);
    }
    // edit product info
    public static function product($id){
        return DB::table('sf_product_info')
            ->select('sf_product_info.*', 'sf_policy.DISC_PCT', 'sf_policy.FREE_QTY')
            ->leftJoin('sf_policy', 'sf_product_info.PRODUCT_ID','=','sf_policy.PRODUCT_ID')
            ->where('sf_product_info.PRODUCT_ID', $id)
            ->first();
    }
    // update data
    public static function updateProductInfo($request, $id, $productImage){
        $data = array(
            'PROD_NAME'    => $request->input('PROD_NAME'),
            'PROD_CODE'    => $request->input('PROD_CODE'),
            'CATEGORY_ID'  => $request->input('CATEGORY_ID'),
            'PACK_TYPE_ID'      => $request->input('PACK_TYPE_ID'),
//            'STRIPS_PRICE' => $request->input('STRIPS_PRICE'),
            'UNIT_PRICE'  => $request->input('UNIT_PRICE'),
//            'BOTTLE_PRICE' => $request->input('BOTTLE_PRICE'),
            'BOX_PRICE'    => $request->input('BOX_PRICE'),
            'IS_SELL_BOX'  => $request->input('IS_SELL_BOX'),
            'INGREDIENTS'  => $request->input('INGREDIENTS'),
            'FUNCTIONALITY'=> $request->input('FUNCTIONALITY'),
            'MANUFACTURE_INFO'=> $request->input('MANUFACTURE_INFO'),
            'ACTIVE_FLG'   => $request->input('ACTIVE_FLG'),
            'UPDATED_BY'   => auth()->user()->id,
            'UPDATED_AT'   => date('Y-m-d h:i:s'),
        );
        if(!empty($productImage)) $data['PRODUCT_IMG'] = $productImage;
        return DB::table('sf_product_info')->where('PRODUCT_ID', '=' , $id)->update($data);
    }

    // view product info
    public static function viewProductInfo($id){
        return DB::table('sf_product_info')
            ->select('sf_product_info.*', 'cat.LDATA_NAME as category', 'typ.LDATA_NAME as type')
            ->leftJoin('sc_lkpdata as cat', 'sf_product_info.CATEGORY_ID','=','cat.LKP_DATAID')
            ->leftJoin('sc_lkpdata as typ', 'sf_product_info.PACK_TYPE_ID','=','typ.LKP_DATAID')
            ->where('PRODUCT_ID', $id)
            ->first();
    }
    public static function viewProductInfoImg($id){
        return DB::table('sf_product_img')
            ->where('PRODUCT_ID', $id)
            ->get();
    }
    // delete product
    public static function deleteProductInfo($id){
         DB::table('sf_product_img')->where('PRODUCT_ID', $id)->delete();
        return DB::table('sf_product_info')->where('PRODUCT_ID', $id)->delete();
    }
    // delete previous image and insert new
    public static function delPreviousImage($id){
        return DB::table('sf_product_img')->where('PRODUCT_ID', $id)->delete();
    }

    public  static function productViewStatus($id){
        return DB::table('sf_product_info')->where('PRODUCT_ID', $id)->first();
    }
    public static function getNewArrivals($take = null){
        return DB::table('sf_product_info')
            ->select('sf_product_info.*', 'sc_lkpdata.LDATA_NAME as TYPE_NAME', 'sf_policy.DISC_PCT', 'sf_policy.FREE_QTY')
            ->leftJoin('sc_lkpdata', 'sf_product_info.PACK_TYPE_ID','=','sc_lkpdata.LKP_DATAID')
            ->leftJoin('sf_policy', 'sf_product_info.PRODUCT_ID','=','sf_policy.PRODUCT_ID')
            ->where('WEBVIEW_FG','=',1)
            ->take($take)
            ->get();
    }

    // =============== FOR PRODUCT INDEX PAGE======================================================
    public static function allProducts(){
        return DB::table('sf_product_info')
            ->select('sf_product_info.*', 'sc_lkpdata.LDATA_NAME as TYPE_NAME', 'sf_policy.DISC_PCT', 'sf_policy.FREE_QTY')
            ->leftJoin('sc_lkpdata', 'sf_product_info.PACK_TYPE_ID','=','sc_lkpdata.LKP_DATAID')
            ->leftJoin('sf_policy', 'sf_product_info.PRODUCT_ID','=','sf_policy.PRODUCT_ID')
            ->where('sf_product_info.ACTIVE_FLG', '=', 1)
            ->orderBy('sf_product_info.PRODUCT_ID', 'DESC')
            ->get();
    }
    public static function topRatedProducts($take=null){
        return DB::table('sf_product_info')
            ->select('sf_product_info.*', 'sc_lkpdata.LDATA_NAME as TYPE_NAME', 'sf_policy.DISC_PCT', 'sf_policy.FREE_QTY')
            ->leftJoin('sc_lkpdata', 'sf_product_info.PACK_TYPE_ID','=','sc_lkpdata.LKP_DATAID')
            ->leftJoin('sf_policy', 'sf_product_info.PRODUCT_ID','=','sf_policy.PRODUCT_ID')
            ->where('sf_product_info.ACTIVE_FLG', '=', 1)
            ->take($take)
            ->get();
    }
    public static function viewProductDetails($id){
        return DB::table('sf_product_info')
            ->select('sf_product_info.*', 'sc_lkpdata.LDATA_NAME as TYPE_NAME', 'sf_policy.DISC_PCT', 'sf_policy.FREE_QTY')
            ->leftJoin('sc_lkpdata', 'sf_product_info.PACK_TYPE_ID','=','sc_lkpdata.LKP_DATAID')
            ->leftJoin('sf_policy', 'sf_product_info.PRODUCT_ID','=','sf_policy.PRODUCT_ID')
            ->where('sf_product_info.PRODUCT_ID', $id)
            ->first();
    }

}// class
