<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;

class ProductPolicy extends Model
{
    public static function policies(){
        return DB::table('sf_policy')
            ->leftJoin('sf_product_info','sf_policy.PRODUCT_ID', '=', 'sf_product_info.PRODUCT_ID')
            ->leftJoin('sc_lkpdata','sf_policy.PACK_TYPE_ID', '=', 'sc_lkpdata.LKP_DATAID')
            ->where('sf_policy.ACTIVE_FLG',1)
            ->get();
    }
    public static function insert($data){
        return DB::table('sf_policy')->insert($data);
    }
    public static function updatePolicy($data, $id){
        return DB::table('sf_policy')->where('POLICY_ID','=', $id)->update($data);
    }
    public static function policy($id){
        return DB::table('sf_policy')
            ->leftJoin('sf_product_info','sf_policy.PRODUCT_ID', '=', 'sf_product_info.PRODUCT_ID')
            ->leftJoin('sc_lkpdata','sf_policy.PACK_TYPE_ID', '=', 'sc_lkpdata.LKP_DATAID')
            ->where('sf_policy.POLICY_ID','=', $id)
            ->first();
    }
    public static function deleteProductPolicy($id){
        return DB::table('sf_policy')->where('POLICY_ID','=', $id)->delete();
    }
}
