<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;

class TermCondition extends Model
{
    public static function termsConditions(){
        return DB::table('sf_terms_conditions')
            ->leftJoin('sc_lkpdata','sf_terms_conditions.PAYMENT_TYPE_ID','=','sc_lkpdata.LKP_DATAID')
            ->get();
    }

    public static function codTermsConditions($id){
        return DB::table('sf_terms_conditions')
            ->where('PAYMENT_TYPE_ID', '=', $id)
            ->where('ACTIVE_FLG', 1)
            ->get();
    }
    public static function onlineTermsConditions($id){
        return DB::table('sf_terms_conditions')
            ->where('PAYMENT_TYPE_ID', '=', $id)
            ->where('ACTIVE_FLG', 1)
            ->get();
    }
    public static function insert($data){
        return DB::table('sf_terms_conditions')->insert($data);
    }
    public static function termCondition($id){
        return DB::table('sf_terms_conditions')->where('TERMS_CONDTIONS_ID', $id)->first();
    }
    public static function updateTermCondition($data, $id){
        return DB::table('sf_terms_conditions')->where('TERMS_CONDTIONS_ID', $id)->update($data);
    }
    public static function deleteTermCondition($id){
        return DB::table('sf_terms_conditions')->where('TERMS_CONDTIONS_ID', $id)->delete();
    }
}
