<?php

namespace App;

use Illuminate\Notifications\Notifiable;
use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;

class User extends Authenticatable
{
    use Notifiable;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */

    protected $table = 'sc_sausers';

    protected $fillable = [
        'username', 'email', 'password'
    ];

    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = [
        'password', 'remember_token',
    ];

    /**
     * The attributes that should be cast to native types.
     *
     * @var array
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
    ];

    public static function userInfo(){
        return Auth::user();
    }

    //=====================================crud starts=================================

    public static function users(){
        return DB::table('sc_sausers')
            ->select('sc_sausers.*','sc_mnlagrp.AGRP_ENAME')
            ->leftJoin('sc_mnlagrp','sc_sausers.MNLAGRP_ID', '=', 'sc_mnlagrp.MNLAGRP_ID')
            ->where('sc_sausers.ASTATUS_FG','=', 1)
            ->get();
    }
    public static function addUser($data){
        return DB::table('sc_sausers')->insert($data);
    }
    public static function editUser($id){
        return DB::table('sc_sausers')->where('id',$id)->first();
    }
    public static function updateUser($request,$id,$fileToUpload){
        if(!empty($request->input('password'))){
            return DB::table('sc_sausers')->where('id',$id)->update([
                'username'   => $request->input('username'),
                'email'      => $request->input('email'),
                'DESGTON_ID' => $request->input('DESGTON_ID'),
                'DEPRTMN_ID' => $request->input('DEPRTMN_ID'),
                'MNLAGRP_ID' => $request->input('MNLAGRP_ID'),
                'password'   => Hash::make($request->input('password')),
                'EFECTIV_DT' => $request->input('EFECTIV_DT'),
                'UEXPIRE_DT' => $request->input('UEXPIRE_DT'),
                'USER_PHOTO' => $fileToUpload,
                'ASTATUS_FG' => $request->input('ASTATUS_FG'),
                'UPDATED_BY' => auth()->user()->id,
                'UPDATED_AT' => date('Y-m-d h:i:s'),
            ]);
        }else{
            return DB::table('sc_sausers')->where('id',$id)->update([
                'username'   => $request->input('username'),
                'email'      => $request->input('email'),
                'DESGTON_ID' => $request->input('DESGTON_ID'),
                'DEPRTMN_ID' => $request->input('DEPRTMN_ID'),
                'MNLAGRP_ID' => $request->input('MNLAGRP_ID'),
                'EFECTIV_DT' => $request->input('EFECTIV_DT'),
                'UEXPIRE_DT' => $request->input('UEXPIRE_DT'),
                'USER_PHOTO' => $fileToUpload,
                'ASTATUS_FG' => $request->input('ASTATUS_FG'),
                'UPDATED_BY' => auth()->user()->id,
                'UPDATED_AT' => date('Y-m-d h:i:s'),
            ]);
        }

    }

    public static function delUser($id){
        return DB::table('sc_sausers')->where('id', $id)->delete();
    }
}
