<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;

class UserGroup extends Model
{
    // get list
    public static function getUserGroups(){
        return DB::table('sc_mnlagrp')->get();
    }
    // add user group
    public static function addUserGroup($data){
        return DB::table('sc_mnlagrp')->insert($data);
    }
    // edit user group
    public static function editUserGroup($id){
        return DB::table('sc_mnlagrp')->where('MNLAGRP_ID','=', $id)->first();
    }
    // update user group
    public static function updateUserGroup($request,$id){
        return DB::table('sc_mnlagrp')->where('MNLAGRP_ID','=', $id)->update([
            'AGRP_ENAME' => $request->input('AGRP_ENAME'),
            'AGRP_N_KEY' => $request->input('AGRP_N_KEY'),
            'PTG_GRP_ID' => $request->input('PTG_GRP_ID'),
            'USERDSL_NO' => $request->input('USERDSL_NO'),
            'ASTATUS_FG' => $request->input('ASTATUS_FG'),
            'UPDATED_BY' => auth()->user()->id,
            'UPDATED_AT' => date('Y-m-d h:i:s'),
       ]);
    }
    // delete user group
    public static function deleteUserGroup($id){
        return DB::table('sc_mnlagrp')->where('MNLAGRP_ID', $id)->delete();
    }
}
