@extends('admin.master')

@section('content')
    <div class="row">
        <div class="col-md-12">
            <div id="accordion">
                @foreach($lookupGroups as $group)
                <div class="card">
                    <div class="card-header" id="headingOne" data-toggle="collapse" data-target="#collapseOne{{ $group->LKP_GRP_ID }}" aria-expanded="true" aria-controls="collapseOne">
                        <a href="#" class="btn btn-danger btn-circle btn-sm float-right mr-1 clickForDelete row{{ $group->LKP_GRP_ID }}" data-token="{{ csrf_token() }}" data-action="{{ url('lookup-group-setup/'.$group->LKP_GRP_ID) }}" role="button"><i class="fas fa-trash"></i></a>
                        <a href="#" class="btn btn-info btn-circle btn-sm float-right mr-1" id="modalOpen" data-action="{{ url('lookup-group-setup/'.$group->LKP_GRP_ID.'/edit') }}" data-modal="modal-md" data-title="Edit Lookup Group Item"  data-toggle="modal" data-target="#openModal"><i class="fas fa-edit"></i></a>
                        <h5 class="mb-0">
                            <button class="btn btn-link" >
                                {{ $group->LKPGRPNAME }} ({{ $group->LKP_GRP_ID }})
                            </button>
                        </h5>
                    </div>

                    <div id="collapseOne{{ $group->LKP_GRP_ID }}" class="collapse" aria-labelledby="headingOne" data-parent="#accordion">
                        <!-- add lookup data -->
                        <button type="button" id="modalOpen" class="btn btn-outline-primary float-right m-3" data-action="{{ url('lookup-data-add/'.$group->LKP_GRP_ID) }}" data-modal="modal-md" data-title="Create Data Item"  data-toggle="modal" data-target="#openModal">Add Lookup Data</button>

                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table table-bordered" id="dataTable" width="100%" cellspacing="0">
                                    <thead>
                                    <tr>
                                        <th>Sl.</th>
                                        <th>Lookup Data Name</th>
                                        <th>Active Status</th>
                                        <th>Action</th>
                                    </tr>
                                    </thead>
                                    @php $sl = 1; @endphp
                                    <tbody>
                                    @foreach($lookupData as $data)
                                        @if($data->LKP_GRP_ID==$group->LKP_GRP_ID)
                                        <tr>
                                            <td>{{ $sl++ }}</td>
                                            <td>{{ $data->LDATA_NAME }}</td>
                                            <td>
                                                @if($data->ASTATUS_FG==1)
                                                    <button class="btn btn-primary btn-sm">Active</button>
                                                @else
                                                    <button class="btn btn-danger btn-sm">Inactive</button>
                                                @endif
                                            </td>
                                            <td>
                                                {{--<button type="button" id="modalOpen" class="btn btn-outline-primary " data-action="{{ url('lookup-data-lookupSetup/1/edit') }}" data-modal="modal-md" data-title="Edit Data Item"  data-toggle="modal" data-target="#openModal">Edit</button>--}}
                                                <a href="#" class="btn btn-info btn-circle btn-sm" id="modalOpen" data-action="{{ url('lookup-data-setup/'.$data->LKP_DATAID.'/edit') }}" data-modal="modal-md" data-title="Edit Data Item"  data-toggle="modal" data-target="#openModal"><i class="fas fa-edit"></i></a>
                                                <a href="#" class="btn btn-danger btn-circle btn-sm clickForDelete row{{ $data->LKP_DATAID }}" data-token="{{ csrf_token() }}" data-action="{{ url('lookup-data-setup/'.$data->LKP_DATAID) }}" role="button"><i class="fas fa-trash"></i></a>
                                            </td>
                                        </tr>
                                        @endif
                                    @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div> <!--/.card -->
                @endforeach
            </div>
        </div>
    </div> <!-- /.row-->
    @include('admin.includes.deleteScript')

@endsection


