@extends('admin.master')
@section('content')
    <!-- Custom styles for this page -->
    <div class="row">
        <div class="col-lg-12 col-md-12">
            <!-- DataTales Example -->
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">User Groups</h6>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-bordered" id="dataTable" width="100%" cellspacing="0">
                            <thead>
                                <tr>
                                    <th>Sl.</th>
                                    <th>Name</th>
                                    <th>Status</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tfoot>
                                <tr>
                                    <th>Sl.</th>
                                    <th>Name</th>
                                    <th>Status</th>
                                    <th>Action</th>
                                </tr>
                            </tfoot>
                            <tbody>
                            @foreach($userGroup as $key => $row)
                                <tr>
                                    <td>{{ ++$key }}</td>
                                    <td>{{ $row->AGRP_ENAME }}</td>
                                    <td>
                                        @if($row->ASTATUS_FG==1)
                                            <button class="btn btn-primary btn-sm">Active</button>
                                        @else
                                            <button class="btn btn-danger btn-sm">Inactive</button>
                                        @endif
                                    </td>
                                    <td>
                                        {{--<a href="#" class="btn btn-success btn-circle btn-sm" id="modalOpen" data-action="{{ url('user-groups/'.$row->MNLAGRP_ID) }}" data-modal="modal-lg" data-title="View User Group"  data-toggle="modal" data-target="#openModal"><i class="fas fa-eye"></i></a>--}}
                                        <a href="#" class="btn btn-info btn-circle btn-sm" id="modalOpen" data-action="{{ url('user-groups/'.$row->MNLAGRP_ID.'/edit') }}" data-modal="modal-md" data-title="Edit User Group"  data-toggle="modal" data-target="#openModal"><i class="fas fa-edit"></i></a>
                                        <a href="#" class="btn btn-danger btn-circle btn-sm clickForDelete" data-token="{{ csrf_token() }}" data-action="{{ url('user-groups/'.$row->MNLAGRP_ID) }}" role="button"><i class="fas fa-trash"></i></a>

                                    </td>
                                </tr>
                            @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div> <!-- ol-lg-12 col-md-12-->
    </div> <!-- /.row-->

    <!--data tables script (added in master)-->
    @include('admin.includes.deleteScript')
@endsection


