<div class="col-md-12">
    <form action="{{ url('users/'.$editUser->id) }}" method="post" enctype="multipart/form-data">
        @method('PUT')
        @csrf
        <div class="row">
            <div class="col-md-6">
                <div class="form-group">
                    <label for="name">Name <span style="color: #ff0000">*</span></label>
                    <input type="text" class="form-control" name="username" value="{{ $editUser->username }}" placeholder="Enter user name" required>
                </div>
            </div>
            <div class="col-md-6">
                <div class="form-group">
                    <label for="email">Email <span style="color: #ff0000">*</span></label>
                    <input type="text" class="form-control" name="email" value="{{ $editUser->email }}" placeholder="Enter user email" required>
                </div>
            </div>
        </div> <!-- /.row-->

        <div class="row">
            <div class="col-md-6">
                <div class="form-group">
                    <label for="department">Department</label>
                    <select class="form-control" name="DEPRTMN_ID">
                        <option value="">-Select-</option>
                        @foreach($departments as $row)
                            <option value="{{ $row->LKP_DATAID }}" @if($row->LKP_DATAID==$editUser->DEPRTMN_ID) selected @endif>{{ $row->LDATA_NAME }}</option>
                        @endforeach
                    </select>
                </div>
            </div>
            <div class="col-md-6">
                <div class="form-group">
                    <label for="designation">Designation</label>
                    <select class="form-control" name="DESGTON_ID">
                        <option value="">-Select-</option>
                        @foreach($designations as $row)
                            <option value="{{ $row->LKP_DATAID }}" @if($row->LKP_DATAID==$editUser->DESGTON_ID) selected @endif>{{ $row->LDATA_NAME }}</option>
                        @endforeach
                    </select>
                </div>
            </div>
        </div> <!-- /.row-->

        <div class="row">
            <div class="col-md-6">
                <div class="form-group">
                    <label for="userGroup">User Group <span style="color: #ff0000">*</span></label>
                    <select class="form-control"  name="MNLAGRP_ID" required>
                        <option value="">-Select-</option>
                        @foreach($userGroups as $userGroup)
                            <option value="{{ $userGroup->MNLAGRP_ID }}" @if($userGroup->MNLAGRP_ID==$editUser->MNLAGRP_ID) selected @endif>{{ $userGroup->AGRP_ENAME }}</option>
                        @endforeach
                    </select>
                </div>
            </div>
            <div class="col-md-6">
                <div class="form-group">
                    <label for="password">Password <span style="color: #ff0000">*</span></label>
                    <input type="password" class="form-control" value="" name="password" placeholder="" required>
                </div>
            </div>
        </div> <!-- /.row-->

        <div class="row">
            <div class="col-md-6">
                <div class="form-group">
                    <label for="effectiveDate">Effective Date</label>
                    <input type="date" class="form-control" value="{{ $editUser->EFECTIV_DT }}" name="EFECTIV_DT" >
                </div>
            </div>
            <div class="col-md-6">
                <div class="form-group">
                    <label for="expiredDate">Expired Date</label>
                    <input type="date" class="form-control" value="{{ $editUser->UEXPIRE_DT }}" name="UEXPIRE_DT" >
                </div>
            </div>
        </div> <!-- /.row-->
        <div class="row">
            <div class="col-md-6">
                <div class="form-group">
                    <label for="photo">Photo</label>
                    <input type="file" class="form-control" name="photo" >
                    <img src="{{ asset('/public/uploads/users/'.$editUser->USER_PHOTO) }}" class="m-1" alt="User Profile Photo" width="50px" height="50px">
                </div>
            </div>
            <div class="col-md-6">
                <div class="form-group">
                    <label for="status">Active Status <span style="color: #ff0000">*</span></label>
                    <select class="form-control" name="ASTATUS_FG">
                        <option value="1" @if($userGroup->ASTATUS_FG==1) selected @endif>Active</option>
                        <option value="0" @if($userGroup->ASTATUS_FG==0) selected @endif>Inactive</option>
                    </select>
                </div>
            </div>
        </div> <!-- /.row-->


        <div class="row">
            <div class="col-md-6">
                {{--<button class="btn btn-outline-secondary" type="button" data-dismiss="modal">close</button>--}}
            </div>
            <div class="col-md-6 row ">
                <button type="submit" class="btn btn-primary float-right ">Submit</button>
            </div>
        </div>
    </form>
</div>