@extends('admin.master')
@section('content')
    <div class="row">
        <div class="col-lg-12 col-md-12">
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">Organizations</h6>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-bordered" id="dataTable" width="100%" cellspacing="0">
                            <thead>
                                <tr>
                                    <th>Sl.</th>
                                    <th>Name</th>
                                    <th>Email</th>
                                    <th>Address</th>
                                    <th>Contact</th>
                                    <th>Status</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tfoot>
                                <tr>
                                    <th>Sl.</th>
                                    <th>Name</th>
                                    <th>Email</th>
                                    <th>Address</th>
                                    <th>Contact</th>
                                    <th>Status</th>
                                    <th>Action</th>
                                </tr>
                            </tfoot>

                            <tbody>
                            @foreach($organizations as $key => $row)
                                <tr>
                                    <td>{{ ++$key }}</td>
                                    <td>{{ $row->ORGANIZATION_NAME }}</td>
                                    <td>{{ $row->ORGANIZATION_EMAIL }}</td>
                                    <td>{{ $row->ORGANIZATION_ADDRESS }}</td>
                                    <td>{{ $row->ORGANIZATION_CONTACT }}</td>
                                    <td>
                                        @if($row->ACTIVE_FLG==1)
                                            <button class="btn btn-primary btn-sm">Active</button>
                                        @else
                                            <button class="btn btn-danger btn-sm">Inactive</button>
                                        @endif
                                    </td>
                                    <td>
                                        {{--<a href="#" class="btn btn-success btn-circle btn-sm" id="modalOpen" data-action="{{ url('organizations/'.$row->ORGANIZATION_ID) }}" data-modal="modal-lg" data-title="View Organization Information"  data-toggle="modal" data-target="#openModal"><i class="fas fa-eye"></i></a>--}}
                                        <a href="#" class="btn btn-info btn-circle btn-sm" id="modalOpen" data-action="{{ url('organizations/'.$row->ORGANIZATION_ID.'/edit') }}" data-modal="modal-lg" data-title="Edit Organization Information"  data-toggle="modal" data-target="#openModal"><i class="fas fa-edit"></i></a>
                                        <a href="#" class="btn btn-danger btn-circle btn-sm clickForDelete row{{ $row->ORGANIZATION_ID }}" data-token="{{ csrf_token() }}" data-action="{{ url('organizations/'.$row->ORGANIZATION_ID) }}" role="button"><i class="fas fa-trash"></i></a>

                                    </td>
                                </tr>
                            @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div> <!-- ol-lg-12 col-md-12-->

    </div> <!-- /.row-->

    @include('admin.includes.deleteScript')

@endsection


