@extends('admin.master')
@section('content')
    <div class="row">
        <div class="col-lg-12 col-md-12">
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">Products</h6>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-bordered" id="dataTable" width="100%" cellspacing="0">
                            <thead>
                                <tr>
                                    <th>Sl.</th>
                                    <th>Name</th>
                                    <th>Code</th>
                                    <th>Type</th>
                                    <th>Unit Price</th>
                                    <th>Box Price</th>
                                    <th>Web View</th>
                                    <th>Status</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tfoot>
                            <tr>
                                <th>Sl.</th>
                                <th>Name</th>
                                <th>Code</th>
                                <th>Type</th>
                                <th>Unit Price</th>
                                <th>Box Price</th>
                                <th>Web View</th>
                                <th>Status</th>
                                <th>Action</th>
                            </tr>
                            </tfoot>

                            <tbody>
                            @foreach($products as $key => $row)
                                <tr>
                                    <td>{{ ++$key }}</td>
                                    <td>{{ $row->PROD_NAME }}</td>
                                    <td>{{ $row->PROD_CODE }}</td>
                                    <td>{{ $row->LDATA_NAME }}</td>
                                    <td>${{ $row->UNIT_PRICE }}</td>
                                    <td>${{ $row->BOX_PRICE }}</td>
                                    <td><input type="checkbox" class="show-product" data-action="{{ url('show-product-in-website/'.$row->PRODUCT_ID) }}" data-token="{{ csrf_token() }}" @if($row->WEBVIEW_FG==1) checked @endif></td>
                                    <td>
                                        @if($row->ACTIVE_FLG==1)
                                            <button class="btn btn-primary btn-sm">Active</button>
                                        @else
                                            <button class="btn btn-danger btn-sm">Inactive</button>
                                        @endif
                                    </td>
                                    <td>
                                        <a href="#" class="btn btn-success btn-circle btn-sm" id="modalOpen" data-action="{{ url('product-info/'.$row->PRODUCT_ID) }}" data-modal="modal-lg" data-title="View Product Information"  data-toggle="modal" data-target="#openModal"><i class="fas fa-eye"></i></a>
                                        <a href="#" class="btn btn-info btn-circle btn-sm" id="modalOpen" data-action="{{ url('product-info/'.$row->PRODUCT_ID.'/edit') }}" data-modal="modal-lg" data-title="Edit Product Information"  data-toggle="modal" data-target="#openModal"><i class="fas fa-edit"></i></a>
                                        <a href="#" class="btn btn-danger btn-circle btn-sm clickForDelete row{{ $row->PRODUCT_ID }}" data-token="{{ csrf_token() }}" data-action="{{ url('product-info/'.$row->PRODUCT_ID) }}" role="button"><i class="fas fa-trash"></i></a>

                                    </td>
                                </tr>
                            @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div> <!-- ol-lg-12 col-md-12-->

    </div> <!-- /.row-->

    @include('admin.includes.deleteScript')

    <script>
        $(document).on('click','.show-product', function () {
            var url = $(this).attr('data-action');
            var _token = $(this).attr('data-token');
            $.ajax({
                url:url,
                token:_token,
                success:(function (data) {

                })
            });


        })
    </script>

@endsection


